"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamGraph = exports.invokeGraph = void 0;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _server = require("@kbn/ml-response-stream/server");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _with_assistant_span = require("../../tracers/apm/with_assistant_span");
var _run_agent = require("./nodes/run_agent");
var _graph = require("./graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Execute the graph in streaming mode
 *
 * @param apmTracer
 * @param assistantGraph
 * @param inputs
 * @param logger
 * @param onLlmResponse
 * @param request
 * @param telemetryTracer
 * @param traceOptions
 */
const streamGraph = async ({
  apmTracer,
  assistantGraph,
  inputs,
  logger,
  onLlmResponse,
  request,
  telemetryTracer,
  traceOptions
}) => {
  var _traceOptions$tracers2, _traceOptions$tags2;
  let streamingSpan;
  if (_elasticApmNode.default.isStarted()) {
    var _agent$startSpan;
    streamingSpan = (_agent$startSpan = _elasticApmNode.default.startSpan(`${_graph.DEFAULT_ASSISTANT_GRAPH_ID} (Streaming)`)) !== null && _agent$startSpan !== void 0 ? _agent$startSpan : undefined;
  }
  const {
    end: streamEnd,
    push,
    responseWithHeaders
  } = (0, _server.streamFactory)(request.headers, logger, false, false);
  let didEnd = false;
  const handleStreamEnd = (finalResponse, isError = false) => {
    var _streamingSpan3, _streamingSpan4, _streamingSpan5;
    if (onLlmResponse) {
      var _streamingSpan, _streamingSpan$transa, _streamingSpan$transa2, _streamingSpan2, _streamingSpan2$ids;
      onLlmResponse(finalResponse, {
        transactionId: (_streamingSpan = streamingSpan) === null || _streamingSpan === void 0 ? void 0 : (_streamingSpan$transa = _streamingSpan.transaction) === null || _streamingSpan$transa === void 0 ? void 0 : (_streamingSpan$transa2 = _streamingSpan$transa.ids) === null || _streamingSpan$transa2 === void 0 ? void 0 : _streamingSpan$transa2['transaction.id'],
        traceId: (_streamingSpan2 = streamingSpan) === null || _streamingSpan2 === void 0 ? void 0 : (_streamingSpan2$ids = _streamingSpan2.ids) === null || _streamingSpan2$ids === void 0 ? void 0 : _streamingSpan2$ids['trace.id']
      }, isError).catch(() => {});
    }
    streamEnd();
    didEnd = true;
    if (streamingSpan && !((_streamingSpan3 = streamingSpan) !== null && _streamingSpan3 !== void 0 && _streamingSpan3.outcome) || ((_streamingSpan4 = streamingSpan) === null || _streamingSpan4 === void 0 ? void 0 : _streamingSpan4.outcome) === 'unknown') {
      streamingSpan.outcome = 'success';
    }
    (_streamingSpan5 = streamingSpan) === null || _streamingSpan5 === void 0 ? void 0 : _streamingSpan5.end();
  };

  // Stream is from tool calling agent or structured chat agent
  if (inputs.isOssModel || (inputs === null || inputs === void 0 ? void 0 : inputs.llmType) === 'bedrock' || (inputs === null || inputs === void 0 ? void 0 : inputs.llmType) === 'gemini') {
    var _traceOptions$tracers, _traceOptions$tags;
    const stream = await assistantGraph.streamEvents(inputs, {
      callbacks: [apmTracer, ...((_traceOptions$tracers = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tracers) !== null && _traceOptions$tracers !== void 0 ? _traceOptions$tracers : []), ...(telemetryTracer ? [telemetryTracer] : [])],
      runName: _graph.DEFAULT_ASSISTANT_GRAPH_ID,
      tags: (_traceOptions$tags = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tags) !== null && _traceOptions$tags !== void 0 ? _traceOptions$tags : [],
      version: 'v2',
      streamMode: 'values'
    }, inputs.isOssModel || (inputs === null || inputs === void 0 ? void 0 : inputs.llmType) === 'bedrock' ? {
      includeNames: ['Summarizer']
    } : undefined);
    for await (const {
      event,
      data,
      tags
    } of stream) {
      if ((tags || []).includes(_run_agent.AGENT_NODE_TAG)) {
        var _data$output$lc_kwarg, _data$output$lc_kwarg2;
        if (event === 'on_chat_model_stream') {
          var _msg$tool_call_chunks;
          const msg = data.chunk;
          if (!didEnd && !((_msg$tool_call_chunks = msg.tool_call_chunks) !== null && _msg$tool_call_chunks !== void 0 && _msg$tool_call_chunks.length) && msg.content.length) {
            push({
              payload: msg.content,
              type: 'content'
            });
          }
        }
        if (event === 'on_chat_model_end' && !((_data$output$lc_kwarg = data.output.lc_kwargs) !== null && _data$output$lc_kwarg !== void 0 && (_data$output$lc_kwarg2 = _data$output$lc_kwarg.tool_calls) !== null && _data$output$lc_kwarg2 !== void 0 && _data$output$lc_kwarg2.length) && !didEnd) {
          handleStreamEnd(data.output.content);
        }
      }
    }
    return responseWithHeaders;
  }

  // Stream is from openai functions agent
  let finalMessage = '';
  let conversationId;
  const stream = assistantGraph.streamEvents(inputs, {
    callbacks: [apmTracer, ...((_traceOptions$tracers2 = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tracers) !== null && _traceOptions$tracers2 !== void 0 ? _traceOptions$tracers2 : []), ...(telemetryTracer ? [telemetryTracer] : [])],
    runName: _graph.DEFAULT_ASSISTANT_GRAPH_ID,
    streamMode: 'values',
    tags: (_traceOptions$tags2 = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tags) !== null && _traceOptions$tags2 !== void 0 ? _traceOptions$tags2 : [],
    version: 'v1'
  });
  const processEvent = async () => {
    try {
      const {
        value,
        done
      } = await stream.next();
      if (done) return;
      const event = value;
      // only process events that are part of the agent run
      if ((event.tags || []).includes(_run_agent.AGENT_NODE_TAG)) {
        if (event.name === 'ActionsClientChatOpenAI') {
          if (event.event === 'on_llm_stream') {
            var _event$data;
            const chunk = (_event$data = event.data) === null || _event$data === void 0 ? void 0 : _event$data.chunk;
            const msg = chunk.message;
            if (msg !== null && msg !== void 0 && msg.tool_call_chunks && (msg === null || msg === void 0 ? void 0 : msg.tool_call_chunks.length) > 0) {
              // I don't think we hit this anymore because of our check for AGENT_NODE_TAG
              // however, no harm to keep it in
              /* empty */
            } else if (!didEnd) {
              push({
                payload: msg.content,
                type: 'content'
              });
              finalMessage += msg.content;
            }
          } else if (event.event === 'on_llm_end' && !didEnd) {
            var _event$data$output, _generations$;
            const generations = (_event$data$output = event.data.output) === null || _event$data$output === void 0 ? void 0 : _event$data$output.generations[0];
            if (generations && ((_generations$ = generations[0]) === null || _generations$ === void 0 ? void 0 : _generations$.generationInfo.finish_reason) === 'stop') {
              var _generations$0$text, _generations$2;
              handleStreamEnd((_generations$0$text = (_generations$2 = generations[0]) === null || _generations$2 === void 0 ? void 0 : _generations$2.text) !== null && _generations$0$text !== void 0 ? _generations$0$text : finalMessage);
            }
          }
        }
      }
      void processEvent();
    } catch (err) {
      // if I throw an error here, it crashes the server. Not sure how to get around that.
      // If I put await on this function the error works properly, but when there is not an error
      // it waits for the entire stream to complete before resolving
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      if (error.message === 'AbortError') {
        // user aborted the stream, we must end it manually here
        return handleStreamEnd(finalMessage);
      }
      logger.error(`Error streaming from LangChain: ${error.message}`);
      if (conversationId) {
        push({
          payload: `Conversation id: ${conversationId}`,
          type: 'content'
        });
      }
      push({
        payload: error.message,
        type: 'content'
      });
      handleStreamEnd(error.message, true);
    }
  };

  // Start processing events, do not await! Return `responseWithHeaders` immediately
  void processEvent();
  return responseWithHeaders;
};
exports.streamGraph = streamGraph;
/**
 * Execute the graph in non-streaming mode
 *
 * @param apmTracer
 * @param assistantGraph
 * @param inputs
 * @param onLlmResponse
 * @param telemetryTracer
 * @param traceOptions
 */
const invokeGraph = async ({
  apmTracer,
  assistantGraph,
  inputs,
  onLlmResponse,
  telemetryTracer,
  traceOptions
}) => {
  return (0, _with_assistant_span.withAssistantSpan)(_graph.DEFAULT_ASSISTANT_GRAPH_ID, async span => {
    var _span$transaction, _traceOptions$tracers3, _traceOptions$tags3, _r$conversation;
    let traceData = {};
    if ((span === null || span === void 0 ? void 0 : (_span$transaction = span.transaction) === null || _span$transaction === void 0 ? void 0 : _span$transaction.ids['transaction.id']) != null && (span === null || span === void 0 ? void 0 : span.ids['trace.id']) != null) {
      traceData = {
        // Transactions ID since this span is the parent
        transactionId: span.transaction.ids['transaction.id'],
        traceId: span.ids['trace.id']
      };
      span.addLabels({
        evaluationId: traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.evaluationId
      });
    }
    const r = await assistantGraph.invoke(inputs, {
      callbacks: [apmTracer, ...((_traceOptions$tracers3 = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tracers) !== null && _traceOptions$tracers3 !== void 0 ? _traceOptions$tracers3 : []), ...(telemetryTracer ? [telemetryTracer] : [])],
      runName: _graph.DEFAULT_ASSISTANT_GRAPH_ID,
      tags: (_traceOptions$tags3 = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tags) !== null && _traceOptions$tags3 !== void 0 ? _traceOptions$tags3 : []
    });
    const output = r.agentOutcome.returnValues.output;
    const conversationId = (_r$conversation = r.conversation) === null || _r$conversation === void 0 ? void 0 : _r$conversation.id;
    if (onLlmResponse) {
      await onLlmResponse(output, traceData);
    }
    return {
      output,
      traceData,
      conversationId
    };
  });
};
exports.invokeGraph = invokeGraph;