"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAssistantGraph = exports.DEFAULT_ASSISTANT_GRAPH_ID = void 0;
var _langgraph = require("@langchain/langgraph");
var _step_router = require("./nodes/step_router");
var _model_input = require("./nodes/model_input");
var _run_agent = require("./nodes/run_agent");
var _execute_tools = require("./nodes/execute_tools");
var _generate_chat_title = require("./nodes/generate_chat_title");
var _get_persisted_conversation = require("./nodes/get_persisted_conversation");
var _persist_conversation_changes = require("./nodes/persist_conversation_changes");
var _respond = require("./nodes/respond");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ASSISTANT_GRAPH_ID = exports.DEFAULT_ASSISTANT_GRAPH_ID = 'Default Security Assistant Graph';
const getDefaultAssistantGraph = ({
  agentRunnable,
  dataClients,
  createLlmInstance,
  logger,
  tools,
  replacements
}) => {
  try {
    // Default graph state
    const graphState = {
      input: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => ''
      },
      lastNode: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => 'start'
      },
      steps: {
        value: (x, y) => x.concat(y),
        default: () => []
      },
      hasRespondStep: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => false
      },
      agentOutcome: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => undefined
      },
      messages: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => []
      },
      chatTitle: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => ''
      },
      llmType: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => 'unknown'
      },
      isStream: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => false
      },
      isOssModel: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => false
      },
      conversation: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => undefined
      },
      conversationId: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => ''
      },
      responseLanguage: {
        value: (x, y) => y !== null && y !== void 0 ? y : x,
        default: () => 'English'
      }
    };

    // Default node parameters
    const nodeParams = {
      logger
    };

    // Put together a new graph using default state from above
    const graph = new _langgraph.StateGraph({
      channels: graphState
    }).addNode(_constants.NodeType.GET_PERSISTED_CONVERSATION, state => (0, _get_persisted_conversation.getPersistedConversation)({
      ...nodeParams,
      state,
      conversationsDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.conversationsDataClient
    })).addNode(_constants.NodeType.GENERATE_CHAT_TITLE, state => (0, _generate_chat_title.generateChatTitle)({
      ...nodeParams,
      state,
      model: createLlmInstance()
    })).addNode(_constants.NodeType.PERSIST_CONVERSATION_CHANGES, state => (0, _persist_conversation_changes.persistConversationChanges)({
      ...nodeParams,
      state,
      conversationsDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.conversationsDataClient,
      replacements
    })).addNode(_constants.NodeType.AGENT, state => (0, _run_agent.runAgent)({
      ...nodeParams,
      state,
      agentRunnable,
      kbDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.kbDataClient
    })).addNode(_constants.NodeType.TOOLS, state => (0, _execute_tools.executeTools)({
      ...nodeParams,
      state,
      tools
    })).addNode(_constants.NodeType.RESPOND, state => (0, _respond.respond)({
      ...nodeParams,
      state,
      model: createLlmInstance()
    })).addNode(_constants.NodeType.MODEL_INPUT, state => (0, _model_input.modelInput)({
      ...nodeParams,
      state
    })).addEdge(_langgraph.START, _constants.NodeType.MODEL_INPUT).addEdge(_constants.NodeType.RESPOND, _langgraph.END).addEdge(_constants.NodeType.GENERATE_CHAT_TITLE, _constants.NodeType.PERSIST_CONVERSATION_CHANGES).addEdge(_constants.NodeType.PERSIST_CONVERSATION_CHANGES, _constants.NodeType.AGENT).addEdge(_constants.NodeType.TOOLS, _constants.NodeType.AGENT).addConditionalEdges(_constants.NodeType.MODEL_INPUT, _step_router.stepRouter, {
      [_constants.NodeType.GET_PERSISTED_CONVERSATION]: _constants.NodeType.GET_PERSISTED_CONVERSATION,
      [_constants.NodeType.AGENT]: _constants.NodeType.AGENT
    }).addConditionalEdges(_constants.NodeType.GET_PERSISTED_CONVERSATION, _step_router.stepRouter, {
      [_constants.NodeType.PERSIST_CONVERSATION_CHANGES]: _constants.NodeType.PERSIST_CONVERSATION_CHANGES,
      [_constants.NodeType.GENERATE_CHAT_TITLE]: _constants.NodeType.GENERATE_CHAT_TITLE
    }).addConditionalEdges(_constants.NodeType.AGENT, _step_router.stepRouter, {
      [_constants.NodeType.RESPOND]: _constants.NodeType.RESPOND,
      [_constants.NodeType.TOOLS]: _constants.NodeType.TOOLS,
      [_constants.NodeType.END]: _langgraph.END
    });
    return graph.compile();
  } catch (e) {
    throw new Error(`Unable to compile DefaultAssistantGraph\n${e}`);
  }
};
exports.getDefaultAssistantGraph = getDefaultAssistantGraph;