"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedHits = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a flattened hit from an Elasticsearch Msearch response
 *
 * It contains the page content and metadata source of a KB document
 */

/**
 * Returns an array of flattened hits from the specified Msearch response
 * that contain the page content and metadata source of KB documents
 *
 * @param maybeMsearchResponse An Elasticsearch Msearch response, which returns the results of multiple searches in a single request
 * @returns Returns an array of flattened hits from the specified Msearch response that contain the page content and metadata source of KB documents
 */
const getFlattenedHits = maybeMsearchResponse => {
  var _maybeMsearchResponse, _maybeMsearchResponse2, _maybeMsearchResponse3;
  return (_maybeMsearchResponse = maybeMsearchResponse === null || maybeMsearchResponse === void 0 ? void 0 : (_maybeMsearchResponse2 = maybeMsearchResponse.hits) === null || _maybeMsearchResponse2 === void 0 ? void 0 : (_maybeMsearchResponse3 = _maybeMsearchResponse2.hits) === null || _maybeMsearchResponse3 === void 0 ? void 0 : _maybeMsearchResponse3.flatMap(hit => {
    var _hit$_source$text, _hit$_source, _hit$_source$metadata, _hit$_source2, _hit$_source2$metadat;
    return {
      pageContent: (_hit$_source$text = hit === null || hit === void 0 ? void 0 : (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source.text) !== null && _hit$_source$text !== void 0 ? _hit$_source$text : '',
      metadata: {
        source: (_hit$_source$metadata = hit === null || hit === void 0 ? void 0 : (_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : (_hit$_source2$metadat = _hit$_source2.metadata) === null || _hit$_source2$metadat === void 0 ? void 0 : _hit$_source2$metadat.source) !== null && _hit$_source$metadata !== void 0 ? _hit$_source$metadata : ''
      }
    };
  })) !== null && _maybeMsearchResponse !== void 0 ? _maybeMsearchResponse : [];
};
exports.getFlattenedHits = getFlattenedHits;