"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadSecurityLabs = exports.getSecurityLabsDocsCount = void 0;
var _globby = _interopRequireDefault(require("globby"));
var _directory = require("langchain/document_loaders/fs/directory");
var _text = require("langchain/document_loaders/fs/text");
var _path = require("path");
var _pMap = _interopRequireDefault(require("p-map"));
var _add_required_kb_resource_metadata = require("./add_required_kb_resource_metadata");
var _constants = require("../../../routes/knowledge_base/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Loads the Elastic Security Labs mdx files into the Knowledge Base.
 */
const loadSecurityLabs = async (kbDataClient, logger) => {
  try {
    var _response$length;
    const docsLoader = new _directory.DirectoryLoader((0, _path.resolve)(__dirname, '../../../knowledge_base/security_labs'), {
      '.md': path => new _text.TextLoader(path)
    }, true);
    const rawDocs = await docsLoader.load();
    // Add additional metadata to set kbResource as esql
    const docs = (0, _add_required_kb_resource_metadata.addRequiredKbResourceMetadata)({
      docs: rawDocs,
      kbResource: _constants.SECURITY_LABS_RESOURCE,
      required: false
    });
    logger.info(`Loading ${docs.length} Security Labs docs into the Knowledge Base`);

    /**
     * Ingest Security Labs docs into the Knowledge Base one by one to avoid blocking
     * Inference Endpoint for too long
     */

    const response = (await (0, _pMap.default)(docs, singleDoc => kbDataClient.addKnowledgeBaseDocuments({
      documents: [singleDoc],
      global: true
    }), {
      concurrency: 1
    })).flat();
    logger.info(`Loaded ${(_response$length = response === null || response === void 0 ? void 0 : response.length) !== null && _response$length !== void 0 ? _response$length : 0} Security Labs docs into the Knowledge Base`);
    return response.length > 0;
  } catch (e) {
    logger.error(`Failed to load Security Labs docs into the Knowledge Base\n${e}`);
    return false;
  }
};
exports.loadSecurityLabs = loadSecurityLabs;
const getSecurityLabsDocsCount = async ({
  logger
}) => {
  try {
    var _await$globby;
    return (_await$globby = await (0, _globby.default)(`${(0, _path.resolve)(__dirname, '../../../knowledge_base/security_labs')}/**/*.md`)) === null || _await$globby === void 0 ? void 0 : _await$globby.length;
  } catch (e) {
    logger.error(`Failed to get Security Labs source docs count\n${e}`);
    return 0;
  }
};
exports.getSecurityLabsDocsCount = getSecurityLabsDocsCount;