"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultGraphState = void 0;
var _constants = require("../constants");
var _get_default_attack_discovery_prompt = require("../nodes/helpers/get_default_attack_discovery_prompt");
var _get_default_refine_prompt = require("../nodes/refine/helpers/get_default_refine_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultGraphState = () => ({
  attackDiscoveries: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => null
  },
  attackDiscoveryPrompt: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => (0, _get_default_attack_discovery_prompt.getDefaultAttackDiscoveryPrompt)()
  },
  anonymizedAlerts: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  combinedGenerations: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  combinedRefinements: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  generationAttempts: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 0
  },
  generations: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  hallucinationFailures: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 0
  },
  refinePrompt: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => (0, _get_default_refine_prompt.getDefaultRefinePrompt)()
  },
  maxGenerationAttempts: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_GENERATION_ATTEMPTS
  },
  maxHallucinationFailures: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_HALLUCINATION_FAILURES
  },
  maxRepeatedGenerations: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_REPEATED_GENERATIONS
  },
  refinements: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  replacements: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  unrefinedResults: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => null
  }
});
exports.getDefaultGraphState = getDefaultGraphState;