"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedAlerts = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedAlerts = async ({
  alertsIndexPattern,
  anonymizationFields,
  esClient,
  onNewReplacements,
  replacements,
  size
}) => {
  var _result$hits, _result$hits$hits;
  if (alertsIndexPattern == null || size == null || (0, _elasticAssistantCommon.sizeIsOutOfRange)(size)) {
    return [];
  }
  const query = (0, _elasticAssistantCommon.getOpenAndAcknowledgedAlertsQuery)({
    alertsIndexPattern,
    anonymizationFields: anonymizationFields !== null && anonymizationFields !== void 0 ? anonymizationFields : [],
    size
  });
  const result = await esClient.search(query);

  // Accumulate replacements locally so we can, for example use the same
  // replacement for a hostname when we see it in multiple alerts:
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  return (_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : (_result$hits$hits = _result$hits.hits) === null || _result$hits$hits === void 0 ? void 0 : _result$hits$hits.map(x => (0, _elasticAssistantCommon.transformRawData)({
    anonymizationFields,
    currentReplacements: localReplacements,
    // <-- the latest local replacements
    getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
    onNewReplacements: localOnNewReplacements,
    // <-- the local callback
    rawData: (0, _elasticAssistantCommon.getRawDataOrDefault)(x.fields)
  }));
};
exports.getAnonymizedAlerts = getAnonymizedAlerts;