"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnonymizedAlertsRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _retrievers = require("@langchain/core/retrievers");
var _get_anonymized_alerts = require("../helpers/get_anonymized_alerts");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var _alertsIndexPattern = /*#__PURE__*/new WeakMap();
var _anonymizationFields = /*#__PURE__*/new WeakMap();
var _esClient = /*#__PURE__*/new WeakMap();
var _onNewReplacements = /*#__PURE__*/new WeakMap();
var _replacements = /*#__PURE__*/new WeakMap();
var _size = /*#__PURE__*/new WeakMap();
class AnonymizedAlertsRetriever extends _retrievers.BaseRetriever {
  constructor({
    alertsIndexPattern,
    anonymizationFields,
    fields,
    esClient,
    onNewReplacements,
    replacements,
    size
  }) {
    super(fields);
    (0, _defineProperty2.default)(this, "lc_namespace", ['langchain', 'retrievers']);
    _classPrivateFieldInitSpec(this, _alertsIndexPattern, void 0);
    _classPrivateFieldInitSpec(this, _anonymizationFields, void 0);
    _classPrivateFieldInitSpec(this, _esClient, void 0);
    _classPrivateFieldInitSpec(this, _onNewReplacements, void 0);
    _classPrivateFieldInitSpec(this, _replacements, void 0);
    _classPrivateFieldInitSpec(this, _size, void 0);
    _classPrivateFieldSet(_alertsIndexPattern, this, alertsIndexPattern);
    _classPrivateFieldSet(_anonymizationFields, this, anonymizationFields);
    _classPrivateFieldSet(_esClient, this, esClient);
    _classPrivateFieldSet(_onNewReplacements, this, onNewReplacements);
    _classPrivateFieldSet(_replacements, this, replacements);
    _classPrivateFieldSet(_size, this, size);
  }
  async _getRelevantDocuments(query, runManager) {
    const anonymizedAlerts = await (0, _get_anonymized_alerts.getAnonymizedAlerts)({
      alertsIndexPattern: _classPrivateFieldGet(_alertsIndexPattern, this),
      anonymizationFields: _classPrivateFieldGet(_anonymizationFields, this),
      esClient: _classPrivateFieldGet(_esClient, this),
      onNewReplacements: _classPrivateFieldGet(_onNewReplacements, this),
      replacements: _classPrivateFieldGet(_replacements, this),
      size: _classPrivateFieldGet(_size, this)
    });
    return anonymizedAlerts.map(alert => ({
      pageContent: alert,
      metadata: {}
    }));
  }
}
exports.AnonymizedAlertsRetriever = AnonymizedAlertsRetriever;