---
title: "Nimbuspwn: Leveraging vulnerabilities to exploit Linux via Privilege Escalation"
slug: "nimbuspwn-leveraging-vulnerabilities-to-exploit-linux-via-privilege-escalation"
date: "2022-06-02"
description: "Microsoft 365 Defender team released a post detailing several identified vulnerabilities. These vulnerabilities allow adversarial groups to escalate privileges on Linux systems, allowing for deployment of payloads, ransomware, or other attacks."
author:
  - slug: jake-king
image: "thumb-report-threat-hunting.png"
category:
  - slug: security-research
---

## Summary

The Microsoft 365 Defender team released a [post](https://www.microsoft.com/security/blog/2022/04/26/microsoft-finds-new-elevation-of-privilege-linux-vulnerability-nimbuspwn/) detailing several identified vulnerabilities. These vulnerabilities allow adversarial groups to easily escalate privileges on Linux systems, allowing for deployment of payloads, ransomware, or other malicious actions. Collectively known as Nimbuspwn, these vulnerabilities include a series of security issues within networkd-dispatcher, specifically directory traversal, symlink race, and [TOCTU](https://en.wikipedia.org/wiki/Time-of-check_to_time-of-use) race conditions.

Details are covered in their [detailed post](https://www.microsoft.com/security/blog/2022/04/26/microsoft-finds-new-elevation-of-privilege-linux-vulnerability-nimbuspwn/), and further information will be available within the two requested CVEs: [CVE-2022-29799](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-29799) and [CVE-2022-29800](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-29800). At the time of publication these CVE IDs are still reserved.

While this class of vulnerability requires local shell access to exploit, it should be considered important for those that currently leverage networkd-dispatcher within their Linux workload environments. A patch by the creator has been implemented to resolve the issue under the guidance of Microsoft, and should be implemented by those that have systems impacted by this vulnerability.

## Detecting Nimbuspwn activity within Elastic

Our research team at Elastic has focused on building out a series of initial detections that leverage Elastic Security, alongside OSquery.

Firstly, those wishing to understand what systems in their environment may be impacted need to determine systems that have networkd-dispatcher installed:

![OSquery search](/assets/images/nimbuspwn-leveraging-vulnerabilities-to-exploit-linux-via-privilege-escalation/elastic-blog-nimbuspwn.png)

Writing an OSquery search that returns the installed version of Networkd-Dispatcher is relatively trivial, and understanding the systems that may be at risk are returned at a glance. In the screenshot above, we can see an example host listed with a version number of 2.1-2, specific to Ubuntu. The version installed within your environment may be slightly different depending on the distribution. An example query has been provided below.

```
Select version from deb_packages rpm_packages where name=’networkd-dispatcher’;
```

We leveraged the initial research paper from Microsoft, determining a specific malicious pattern adversaries may use to exploit this vulnerability:

![EQL Detection Rule to detect suspicious child processes of Networkd-Dispatcher](/assets/images/nimbuspwn-leveraging-vulnerabilities-to-exploit-linux-via-privilege-escalation/elastic-blog-nimbuspwn-2.jpg)

The Elastic Security team wrote an EQL Detection Rule to detect suspicious child processes of Networkd-Dispatcher. Any child-process detected by this rule should be considered highly suspicious given the circumstances, and should be investigated. Further analysis will likely be provided as our security community builds more POCs for this exploit. An example query appears below:

```
process where event.type == "start" and process.parent.name : "networkd-dispatcher" and not process.name in ("networkctl", "networkd-dispatcher")
```

Given the nature of this exploit, we expect far greater diversity in POCs over the coming weeks. You can expect updates in the form of further signatures or rules accordingly.

## Defensive recommendations

Organizations impacted by vulnerabilities discovered by the Microsoft team should follow guidance provided by Microsoft in their initial post, and update their instances of networkd-dispatcher. Elastic recommends investigating hosts that are found to be running vulnerable versions of network-dispatcher with the aforementioned detections for any sign of compromise.

Not already using Elastic Security? You can always get started with a [free 14-day trial](https://cloud.elastic.co/registration) of Elastic Cloud.
