---
title: "Elastic Security Labs discovers the LOBSHOT malware"
slug: "elastic-security-labs-discovers-lobshot-malware"
date: "2023-05-16"
subtitle: "An analysis of LOBSHOT, an hVNC malware family spreading through Google Ads."
description: "Elastic Security Labs is naming a new malware family, LOBSHOT. LOBSHOT propagates and infiltrates targeted networks through Google Ads and hVNC sessions to deploy backdoors masquerading as legitimate application installers."
author:
  - slug: daniel-stepanic
image: "photo-edited-08@2x.jpg"
category:
  - slug: malware-analysis
tags:
  - lobshot
  - ref5873
---

## Key takeaways

- Adversaries continue to abuse and increase reach through malvertising such as Google Ads by impersonating legitimate software
- Elastic Security Labs is shedding light on an undiscovered hVNC malware that has been quietly collecting a large install base
- This malware we are calling LOBSHOT appears to be leveraged for financial purposes employing banking trojan and info-stealing capabilities

## Preamble

Elastic Security Labs along with the research community noticed a large spike in the adoption of malvertising earlier this year. Attackers promoted their malware using an elaborate scheme of fake websites through Google Ads and embedding backdoors in what appears to users as legitimate installers. In this post, we will highlight one malware family we observed from this spike we’re calling LOBSHOT. LOBSHOT continues to collect victims while staying under the radar.

One of LOBSHOT’s core capabilities is around its hVNC (Hidden Virtual Network Computing) component. These kinds of modules allow for direct and unobserved access to the machine. This feature continues to be successful in bypassing fraud detection systems and is often baked into many popular families as plugins.

We will walk through the LOBSHOT infection chain and its behaviors. Additionally, we will provide a YARA signature and configuration extractor for this family.

![LOBSHOT infection chain](/assets/images/elastic-security-labs-discovers-lobshot-malware/image9.png)

Throughout our analysis, we observed infrastructure known to belong to [TA505](https://malpedia.caad.fkie.fraunhofer.de/actor/ta505). TA505 is a well-known cybercrime group associated with Dridex, Locky, and Necurs campaigns. A loader documented by Proofpoint, known as [Get2](https://www.proofpoint.com/us/threat-insight/post/ta505-distributes-new-sdbbot-remote-access-trojan-get2-downloader), has also been tied to the same domains in the past that we observed with LOBSHOT. We assess with moderate confidence that LOBSHOT is a new malware capability leveraged by TA505 starting in 2022.

## Campaign context

Earlier this year, Elastic Security Labs observed multiple infections with an interesting chain of events that resulted in the execution of an unknown hVNC malware, which we are calling LOBSHOT. Around this same time, similar infection chains were observed in the security community with commonalities of users searching for legitimate software downloads that ended up getting served illegitimate software from promoted ads from Google [[1](https://www.spamhaus.com/resource-center/a-surge-of-malvertising-across-google-ads-is-distributing-dangerous-malware/), [2](https://twitter.com/1ZRR4H/status/1617661947851464704?s=20), [3](https://twitter.com/Malwar3Ninja/status/1617423187415044099?s=20), [4](https://twitter.com/malwrhunterteam/status/1617605240316129280?s=20)].

In one example, the malicious ad was for a legitimate remote desktop solution, AnyDesk. Careful examination of the URL goes to `https://www.amydecke[.]website` instead of the legitimate AnyDesk URL, `https://www.anydesk[.]com`.

![Malicious Google Ad](/assets/images/elastic-security-labs-discovers-lobshot-malware/image22.jpg)

The landing pages were very convincing with similar branding as the legitimate software and included Download Now buttons that pointed to an MSI installer.

![Fake AnyDesk landing page for installer](/assets/images/elastic-security-labs-discovers-lobshot-malware/image13.jpg)

Thanks to security researcher [Will Dormann](https://twitter.com/wdormann), we were able to [view](https://twitter.com/wdormann/status/1617612216945250304?s=20) the screenshots from the AnyDesk campaign.

![Tweet referencing AnyDesk infection chain](/assets/images/elastic-security-labs-discovers-lobshot-malware/image15.jpg)

At the time of publication, we haven’t seen any previous public information about LOBSHOT, so we will focus our research on LOBSHOT’s functionality and capabilities.

## LOBSHOT code analysis

To focus on the LOBSHOT malware, we will skip the initial infection chain. For these initial details, here is a good [sandbox](https://www.joesandbox.com/analysis/787624/0/html) report to look over for general TTPs. We have observed over 500 unique LOBSHOT samples since last July. The samples we have observed are compiled as 32-bit DLLs or 32-bit executables typically ranging around **93** KB to **124** KB. Consider the following [sample](https://www.virustotal.com/gui/file/e4ea88887753a936eaf3361dcc00380b88b0c210dcbde24f8f7ce27991856bf6) representative of LOBSHOT for purposes of this analysis.

### Dynamic API resolution

In our LOBSHOT sample, like most malware we see today, it employs dynamic import resolution to evade security products and slow down the rapid identification of its capabilities. This process involves resolving the names of the Windows APIs that the malware needs at runtime as opposed to placing the imports into the program ahead of time.

![Resolving Windows Registry APIs through LoadLibraryA/GetProcessAddress](/assets/images/elastic-security-labs-discovers-lobshot-malware/image10.jpg)

### Defender emulation check

After the initial libraries are loaded, LOBSHOT performs a Windows Defender anti-emulation check by verifying if the computer name matches the string **HAL9TH** and if the username matches **JohnDoe**. These are hard-coded values within the emulation layer of Defender, if they are present, the malware immediately stops running. This kind of verification has been incorporated in many other stealers including Arkei, Vidar, and Oski. Below is the emulation output using the [Qiling](https://github.com/qilingframework/qiling) framework highlighting these verification checks.

![Defender checks via Qiling](/assets/images/elastic-security-labs-discovers-lobshot-malware/image30.jpg)

### String obfuscation

This malware hides its primary strings through a straightforward encryption function using different bitwise operators. To perform the string decryption, LOBSHOT uses an initial seed from the [WTS_SESSION_INFO](https://learn.microsoft.com/en-us/windows/desktop/api/wtsapi32/ns-wtsapi32-wts_session_infoa) structure from a call to **WTSEnumerateSessionsA.**

![LOBSHOT calling WTSEnumerateSessionsA](/assets/images/elastic-security-labs-discovers-lobshot-malware/image29.jpg)

In this case, the malware developer sets up the initial seed by performing an XOR on the **SessionID** (always a **0** ) and the **S** char from “Services”.

![WTS_SESSION_INFO structure used as the initial seed for string decryption](/assets/images/elastic-security-labs-discovers-lobshot-malware/image4.jpg)

### Initial enumeration

Before sending any outbound network requests, LOBSHOT builds a custom structure containing enumerated data from the machine including:

- GUID of machine derived from **SOFTWARE\Microsoft\Cryptography\MachineGuid**
- Windows edition, username, computer name
- A VM check, number of processes running, process ID, parent process of malware
- Windows desktop object details
  - Screen height/width
  - Display device information
  - Handles to the desktop objects and windows
  - DPI for the display(s)

![Malware retrieving Windows desktop object information](/assets/images/elastic-security-labs-discovers-lobshot-malware/image12.jpg)

### Execution flow

After LOBSHOT is executed, it moves a copy of itself to the **C:\ProgramData** folder, spawning a new process using **explorer.exe** , terminating the original process, and finally deleting the original file. This design choice is used in an attempt to break the process tree ancestry; making it harder to spot for analysts.

![The LOBSHOT process tree as observed with Elastic Defend](/assets/images/elastic-security-labs-discovers-lobshot-malware/image5.jpg)

Below is a screenshot after the initial execution, the malware is now parentless and running from the **C:\ProgramData** directory.

![ LOBSHOT running without a parent process](/assets/images/elastic-security-labs-discovers-lobshot-malware/image25.jpg)

### Persistence

For persistence, LOBSHOT leverages the [Registry run key persistence method](https://attack.mitre.org/techniques/T1547/001/). In our sample, this is placed in the **HKEY_CURRENT_USER** Registry hive with a randomly generated name pointing to the malware located in **C:\ProgramData.**

![Registry key persistence](/assets/images/elastic-security-labs-discovers-lobshot-malware/image18.jpg)

In addition, it sets Registry key data under the **Software\Microsoft\Windows NT\CurrentVersion\Devices** key path which is used to check for a hardcoded global identifier key that would indicate the system had already been infected. In our sample, the **Display** value is set to the string **134a1160**. The results from the stealer feature are recorded inside the **Default Printer** value. We'll discuss the stealer functionality in the next section.

![Registry hive used to store data](/assets/images/elastic-security-labs-discovers-lobshot-malware/image16.jpg)

### Stealer functionality

With the persistence mechanism established, LOBSHOT starts a new thread kicking off the stealer functionality. It starts by targeting specific Google Chrome extensions that deal with cryptocurrency wallets. Below are Procmon outputs showing LOBSHOT trying to access 32 Chrome wallet extensions, nine Edge wallet extensions, and 11 Firefox wallet extensions.

![Chrome extensions related to cryptocurrency wallets](/assets/images/elastic-security-labs-discovers-lobshot-malware/image14.jpg)

![Edge extensions related to cryptocurrency wallets](/assets/images/elastic-security-labs-discovers-lobshot-malware/image3.jpg)

![Firefox extensions related to cryptocurrency wallets](/assets/images/elastic-security-labs-discovers-lobshot-malware/image2.jpg)

For the complete listing of the different cryptocurrencies mapped to their extension IDs, see the [appendix](https://www.elastic.co/security-labs/elastic-security-labs-discovers-lobshot-malware#appendix).

If there is a match with any of these extensions, the results are inserted in the **Software\Microsoft\Windows NT\CurrentVersion\Devices** Registry key value as binary data with the format of browser name_extension name. Below is an example after the registry modification showing: **Chrome_Yoroi**.

![Stealer component writing found wallet to registry](/assets/images/elastic-security-labs-discovers-lobshot-malware/image7.jpg)

After the browser extensions are enumerated, there is a check for a hardcoded file titled **hmr\_\*.dat** inside the **C:\ProgramData** directory. If this file exists it will be executed with **rundll32.exe** with the following command-line arguments:

**rundll32.exe "C:\ProgramData\hmr_1.dat", #1 hmod**

While we didn’t observe this behavior directly, this function appears to show off a feature baked in by the developer allowing the ability for additional execution options such as loading their own DLL.

### Network communications

For each LOBSHOT sample we have reviewed, there is a hardcoded IP and port that is decrypted from the binary that is used as the primary C2. The malware beacons every 5 seconds communicating by using the following calls:

- **ws2_32.socket**
- **ws2_32.connect**
- **ws2_32.send**
- **ws2_32.select**
- **ws2_32.recv**
- **ws2_32.shutdown**
- **ws2_32.closesocket**

On these outbound requests, it sends pseudorandom hard-coded data along with a shortened GUID value and version number of the module.

![Hardcoded values and version in request](/assets/images/elastic-security-labs-discovers-lobshot-malware/image20.jpg)

Below is an example of the send request buffer sent during the initial outbound requests showing the above-hardcoded values and version number.

![Request buffer on outbound network traffic](/assets/images/elastic-security-labs-discovers-lobshot-malware/image27.jpg)

![Hardcoded values within outbound network traffic request](/assets/images/elastic-security-labs-discovers-lobshot-malware/image19.jpg)

Searching for the above **mov** instruction paired with the first **DWORD** of the hardcoded value ( **C7 06 25 56 0A DC** ) shows over **550** samples in VirusTotal within the last year. With some of the first samples showing up in late July 2022. The prevalence of these hardcoded values shows that it has been actively used and under development for a long period of time, and will likely continue to be used in the future.

![VirusTotal VTGrep search on hardcoded bytes](/assets/images/elastic-security-labs-discovers-lobshot-malware/image26.jpg)

After this initial handshake, LOBSHOT will send the previous custom data structure containing the enumerated data such as the hostname, username, windows objects, etc. over this port.

![The Wireshark output of outbound requests containing victim host information](/assets/images/elastic-security-labs-discovers-lobshot-malware/image17.jpg)

### Capabilities

One of LOBSHOT’s core capabilities is around its hVNC (Hidden Virtual Network Computing) module.

> Unlike traditional VNC (Virtual Network Computing) where the software provides remote access to a machine with the user’s consent and the visibility of the actions taken on the machine can be clearly observed. hVNC acts in the opposite way designed to stay stealthy where all actions by an attacker are taking place on the same machine, but can’t be visibly observed by the victim. hVNC became a popular solution within the banking trojan space to bypass device and fraud detection solutions. More details on hVNC can be found [here](https://deepsec.net/docs/Slides/2017/Who_Hid_My_Desktop_Or_Safran_Pavel_Asinovsky.pdf).

LOBSHOT implements the hVNC feature by generating a hidden desktop using the **CreateDesktopW** Windows API and then assigning the desktop to the malware using the **SetThreadDesktop** API **.** A new Windows **explorer.exe** process is then created under the context of the new hidden desktop.

![LOBSHOT’s hidden desktop creation](/assets/images/elastic-security-labs-discovers-lobshot-malware/image21.jpg)

At this stage, the victim machine will start sending screen captures that represent the hidden desktop that is sent to a listening client controlled by the attacker. The attacker interacts with the client by controlling the keyboard, clicking buttons, and moving the mouse, these capabilities provide the attacker full remote control of the device.

Within LOBSHOT’s hVNC module, there is a built-in GUI menu that allows the attacker to run the following commands quickly:

- Start new **explorer.exe** process
- Start Windows Run command
- Start new Windows process with provided command
- Start Browsers (Internet Explorer, Edge, Firefox)
- Terminate existing explorer.exe processes and start new explorer.exe process
- Tamper with Windows sound settings
- Set/retrieve Clipboard text
- Activate Start Menu
- Modify DPI Awareness settings

![Execute the run dialog inside the hVNC module](/assets/images/elastic-security-labs-discovers-lobshot-malware/image8.jpg)

![Clipboard grabber inside the hVNC module](/assets/images/elastic-security-labs-discovers-lobshot-malware/image11.jpg)

![CMD execution inside the hVNC module](/assets/images/elastic-security-labs-discovers-lobshot-malware/image6.jpg)

While the main functionality is centered on LOBSHOT’s hVNC module, it does have additional capabilities. One example is its ability to swap out its C2 provided by an operator; it manages this by writing the new C2 details into the registry key path **Software\Microsoft\Windows NT\CurrentVersion\Devices** under the **Video** value.

![Updating C2 through registry modification](/assets/images/elastic-security-labs-discovers-lobshot-malware/image24.jpg)

LOBSHOT also includes an update mechanism where it will remove previous modifications to the registry such as removing the “Display” value and Run key persistence, starting a new process, and finally exiting the existing process.

![Remove existing registry key](/assets/images/elastic-security-labs-discovers-lobshot-malware/image28.jpg)

![Spawn new LOBSHOT process](/assets/images/elastic-security-labs-discovers-lobshot-malware/image1.jpg)

## LOBSHOT configuration extractor

Elastic Security Labs has released an open source tool, under the Elastic 2.0 license, that will allow for configurations to be extracted from LOBSHOT samples. The tool can be downloaded [here](https://github.com/elastic/labs-releases/tree/main/extractors/lobshot).

![](/assets/images/elastic-security-labs-discovers-lobshot-malware/image23.jpg)

The extractor can run at the individual file or directory level, examples are below:

- **python lobshot_config_extractor.py --file sample.bin**
- **python lobshot_config_extractor.py --directory samples**

## Summary

Threat groups are continuing to leverage malvertising techniques to masquerade legitimate software with backdoors like LOBSHOT. These kinds of malware seem small, but end up packing significant functionality which helps threat actors move quickly during the initial access stages with fully interactive remote control capabilities. We are continuing to see new samples related to this family each week, and expect it to be around for some time.

## Detection logic

### Prevention

- [Suspicious Windows Explorer Execution](https://github.com/elastic/protections-artifacts/blob/main/behavior/rules/defense_evasion_suspicious_windows_explorer_execution.toml)
- [Suspicious Parent-Child Relationship](https://github.com/elastic/protections-artifacts/blob/main/behavior/rules/defense_evasion_suspicious_parent_child_relationship.toml)
- [Windows.Trojan.Lobshot](https://github.com/elastic/protections-artifacts/blob/main/yara/rules/Windows_Trojan_Lobshot.yar)

### Detection

#### EQL query

Using the Timeline section of the Security Solution in Kibana under the “Correlation” tab, you can use the below EQL queries to hunt for behaviors similar

The following EQL query can be used to detect suspicious grandparent, parent, child relationships observed with LOBSHOT.

```
sequence by host.id, user.id with maxspan=1m
 [process where event.type == "start" and not startsWith~(process.executable, process.parent.executable)] by process.parent.name, process.entity\_id
 [file where event.type == "deletion"] by file.name, process.entity\_id
 [process where event.type == "start" and not startsWith~(process.executable, process.parent.executable)] by process.name, process.parent.entity\_id
until [process where event.type == "end"] by process.name, process.entity\_id
```

#### YARA rule

```
rule Windows_Trojan_Lobshot {
    meta:
        author = "Elastic Security"
        creation_date = "2023-04-18"
        last_modified = "2023-04-18"
        license = "Elastic License v2"
        os = "Windows"
        threat_name = "Windows.Trojan.Lobshot"
        reference_sample = "e4ea88887753a936eaf3361dcc00380b88b0c210dcbde24f8f7ce27991856bf6"
    strings:
        $str0 = "HVNC Remote Control" ascii fullword
        $str1 = " Error # %d - %08lx" ascii fullword
        $str2 = "Set  clipboard text failed." ascii fullword
        $str3 = "OK %08lx %08lx %d" ascii fullword
        $str4 = "\") & (rundll32.exe \"" wide fullword
        $str5 = "%LOCALAPPDATA%\\svc.db" wide fullword
        $str6 = "cmd.exe /c (ping -n 10 127.0.0.1) & (del /F /Q \"" wide fullword
        $seq_str_decrypt = { 8A 5A ?? 8D 52 ?? 80 EB ?? 85 FF 74 ?? C0 E0 ?? 2C ?? 0A C3 32 C1 32 C7 88 06 32 E8 83 C6 ?? 83 C5 ?? EB ?? }
        $seq_emu_check = { 8B 35 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 44 24 ?? C7 44 24 ?? 48 41 4C 39 50 C7 44 24 ?? 54 48 00 00 FF D6 }
        $seq_enum_xor = { FF 15 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 83 7C 24 ?? 00 0F 84 ?? ?? ?? ?? 8B 4C 24 ?? 68 07 80 00 00 8B 41 ?? 8A 00 32 01 A2 ?? ?? ?? ?? }
        $seq_create_guid = { 8D 48 ?? 80 F9 ?? 77 ?? 2C ?? C1 E2 ?? 46 0F B6 C8 0B D1 83 FE ?? 7C ?? 5F 8B C2 5E C3 }
    condition:
        2 of ($seq*) or 5 of ($str*)
}
```

## Observed adversary tactics and techniques

Elastic uses the MITRE ATT&CK framework to document common tactics, techniques, and procedures that advanced persistent threats use against enterprise networks.

### Tactics

Tactics represent the why of a technique or sub-technique. It is the adversary’s tactical goal: the reason for performing an action.

- [Initial access](https://attack.mitre.org/tactics/TA0001)
- [Execution](https://attack.mitre.org/tactics/TA0002)
- [Persistence](https://attack.mitre.org/tactics/TA0003)
- [Command and control](https://attack.mitre.org/tactics/TA0011)
- [Defense evasion](https://attack.mitre.org/tactics/TA0005)

### Techniques / Sub techniques

Techniques and Sub techniques represent how an adversary achieves a tactical goal by performing an action.

- [Boot or Logon Autostart Execution: Registry Run Keys / Startup Folder](https://attack.mitre.org/techniques/T1547/001/)
- [Data from Local System](https://attack.mitre.org/techniques/T1005/)
- [System Owner/User Discovery](https://attack.mitre.org/techniques/T1033/)
- [Obfuscated Files or Information: Dynamic API Resolution](https://attack.mitre.org/techniques/T1027/007/)
- [Remote Services: VNC](https://attack.mitre.org/techniques/T1021/005/)
- [Exfiltration Over C2 Channel](https://attack.mitre.org/techniques/T1041/)
- [Clipboard Data](https://attack.mitre.org/techniques/T1115/)

## Observations

All observables are also available for download in both [ECS and STIX format](https://github.com/elastic/labs-releases/tree/main/indicators/lobshot). Additionally, we have created a [VirusTotal Collection](https://www.virustotal.com/gui/collection/abe7f5f8c49b387114e46957feb347af705d1d90733f4b26341e2e5299cbbf4c) with all indicators.

| Indicator                                                        | Type       | Reference  |
| ---------------------------------------------------------------- | ---------- | ---------- |
| 95.217.125.200                                                   | IP Address | LOBSHOT C2 |
| e4ea88887753a936eaf3361dcc00380b88b0c210dcbde24f8f7ce27991856bf6 | SHA-256    | LOBSHOT    |

## References

The following were referenced throughout the above research:

- [https://malpedia.caad.fkie.fraunhofer.de/actor/ta505](https://malpedia.caad.fkie.fraunhofer.de/actor/ta505)
- [https://twitter.com/wdormann/status/1617612216945250304?s=20](https://twitter.com/wdormann/status/1617612216945250304?s=20)
- [https://www.malware-traffic-analysis.net/2023/01/23/index.html](https://www.malware-traffic-analysis.net/2023/01/23/index.html)

## Appendix

### Chrome wallet extensions

| Wallet name            | Extension ID                     |
| ---------------------- | -------------------------------- |
| Yoroi                  | ffnbelfdoeiohenkjibnmadjiehjhajb |
| TronLink               | ibnejdfjmmkpcnlpebklmnkoeoihofec |
| Nifty Wallet           | jbdaocneiiinmjbjlgalhcelgbejmnid |
| MetaMask               | nkbihfbeogaeaoehlefnkodbefgpgknn |
| Math Wallet            | afbcbjpbpfadlkmhmclhkeeodmamcflc |
| Coinbase Wallet        | hnfanknocfeofbddgcijnmhnfnkdnaad |
| Binance Wallet         | fhbohimaelbohpjbbldcngcnapndodjp |
| Brave Wallet           | odbfpeeihdkbihmopkbjmoonfanlbfcl |
| Guarda                 | hpglfhgfnhbgpjdenjgmdgoeiappafln |
| Equal Wallet           | blnieiiffboillknjnepogjhkgnoapac |
| Jaxx Liberty           | cjelfplplebdjjenllpjcblmjkfcffne |
| BitApp Wallet          | fihkakfobkmkjojpchpfgcmhfjnmnfpi |
| iWallet                | kncchdigobghenbbaddojjnnaogfppfj |
| Wombat                 | amkmjjmmflddogmhpjloimipbofnfjih |
| Oxygen                 | fhilaheimglignddkjgofkcbgekhenbh |
| MyEtherWallet          | nlbmnnijcnlegkjjpcfjclmcfggfefdm |
| GuildWallet            | nanjmdknhkinifnkgdcggcfnhdaammmj |
| Saturn Wallet          | nkddgncdjgjfcddamfgcmfnlhccnimig |
| Ronin Wallet           | fnjhmkhhmkbjkkabndcnnogagogbneec |
| Station Wallet         | aiifbnbfobpmeekipheeijimdpnlpgpp |
| Harmony                | fnnegphlobjdpkhecapkijjdkgcjhkib |
| Coin98 Wallet          | aeachknmefphepccionboohckonoeemg |
| EVER Wallet            | cgeeodpfagjceefieflmdfphplkenlfk |
| KardiaChain Wallet     | pdadjkfkgcafgbceimcpbkalnfnepbnk |
| Phantom                | bfnaelmomeimhlpmgjnjophhpkkoljpa |
| Pali Wallet            | mgffkfbidihjpoaomajlbgchddlicgpn |
| BOLT X                 | aodkkagnadcbobfpggfnjeongemjbjca |
| Liquality Wallet       | kpfopkelmapcoipemfendmdcghnegimn |
| XDEFI Wallet           | hmeobnfnfcmdkdcmlblgagmfpfboieaf |
| Nami                   | lpfcbjknijpeeillifnkikgncikgfhdo |
| MultiversX DeFi Wallet | dngmlblcodfobpdpecaadgfbcggfjfnm |

### Edge wallet extensions

| Wallet name    | Extension ID                     |
| -------------- | -------------------------------- |
| Yoroi          | akoiaibnepcedcplijmiamnaigbepmcb |
| MetaMask       | ejbalbakoplchlghecdalmeeeajnimhm |
| Math Wallet    | dfeccadlilpndjjohbjdblepmjeahlmm |
| Ronin Wallet   | kjmoohlgokccodicjjfebfomlbljgfhk |
| Station Wallet | ajkhoeiiokighlmdnlakpjfoobnjinie |
| BDLT Wallet    | fplfipmamcjaknpgnipjeaeeidnjooao |
| Glow           | niihfokdlimbddhfmngnplgfcgpmlido |
| OneKey         | obffkkagpmohennipjokmpllocnlndac |
| MetaWallet     | kfocnlddfahihoalinnfbnfmopjokmhl |

### Firefox wallet extensions

| Wallet name  | Extension ID                                 |
| ------------ | -------------------------------------------- |
| Yoroi        | \{530f7c6c-6077-4703-8f71-cb368c663e35\}.xpi |
| Ronin Wallet | ronin-wallet@axieinfinity.com.xpi            |
| MetaMask     | webextension@metamask.io.xpi                 |
| TronLink     | \{5799d9b6-8343-4c26-9ab6-5d2ad39884ce\}.xpi |
|              | \{aa812bee-9e92-48ba-9570-5faf0cfe2578\}.xpi |
|              | \{59ea5f29-6ea9-40b5-83cd-937249b001e1\}.xpi |
|              | \{d8ddfc2a-97d9-4c60-8b53-5edd299b6674\}.xpi |
| Phantom      | \{7c42eea1-b3e4-4be4-a56f-82a5852b12dc\}.xpi |
|              | \{b3e96b5f-b5bf-8b48-846b-52f430365e80\}.xpi |
|              | \{eb1fb57b-ca3d-4624-a841-728fdb28455f\}.xpi |
|              | \{76596e30-ecdb-477a-91fd-c08f2018df1a\}.xpi |
