---
title: "Elastic's response to the Spring4Shell vulnerability (CVE-2022-22965)"
slug: "elastic-response-to-the-the-spring4shell-vulnerability-cve-2022-22965"
date: "2022-11-22"
description: "Provide executive-level details about CVE-2022-22965, a recently-disclosed remote code execution (RCE) vulnerability also known as “Spring4Shell”."
author:
  - slug: devon-kerr
image: "thumbnail-security-logos-lock.png"
category:
  - slug: security-research
  - slug: vulnerability-updates
---

On March 29, 2022 a vulnerability in the [Spring framework](https://spring.io/projects/spring-framework) was [disclosed](https://tanzu.vmware.com/security/cve-2022-22965) to the public by VMware. This vulnerability had several prerequisites affecting impact:

- Spring framework versions 5.3.0-5.3.17, 5.2.0-5.2.19, potentially software versions prior to 5.2.x
- An application running as a Spring MVX or WebFlux object
- Apache Tomcat as the container for that application
- The application packaged as a Web Application Resource (WAR)

Specifically, this vulnerability targets the ClassLoader() class, though similar undiscovered vulnerabilities in other classes are likely. A URI parameter can be passed to Tomcat as part of a standard web request to exploit this vulnerability.

## What is the threat?

CVE-2022-22965 is a vulnerability that may affect systems on which the Spring Framework has been installed, and which expose Spring MVC or WebFlux applications running on JDK 9 or later. The exploit associated with this vulnerability requires Apache Tomcat, and that applications are deployed as Web Application Resources (WARs) — but enterprises should consider that other methods of exploitation are also possible.

## What is the impact?

If successfully exploited, the Spring4Shell vulnerability may permit an adversary to execute arbitrary code (including malware) in the context of the web server. Because specific software, versions, and configurations are required as prerequisites, enterprises should expect a less impact than a vulnerability like [Log4Shell](https://www.elastic.co/blog/analysis-of-log4shell-cve-2021-45046). While Spring4Shell has more specific prerequisites to cause impact, Elastic Security still recommends [following official guidance](https://spring.io/blog/2022/03/31/spring-framework-rce-early-announcement) regarding patching and upgrading.

## Leveraging Elastic for exploit detection

Prebuilt protections that generically identify aspects of successful exploitation already exist in community-facing repositories:

- [Webshell Detection: Script Process Child of Common Web Processes](https://github.com/elastic/detection-rules/blob/6bdfddac8edea5e327bf28aed7e6dc4a7f701dc6/rules/windows/persistence_webshell_detection.toml)
- [Potential Shell via Web Server](https://github.com/elastic/detection-rules/blob/414d32027632a49fb239abb8fbbb55d3fa8dd861/rules/linux/persistence_shell_activity_by_web_server.toml)

Additionally, Elastic [provides](https://github.com/elastic/detection-rules) dozens of rules for common and uncommon post-exploitation techniques, which may appear in later stages of an intrusion attempt.

### Artifacts

Elastic’s community-facing [detection-rules repository](https://github.com/elastic/detection-rules) contains two rules specific to webserver post-exploitation. Due to the unpredictable nature of vulnerabilities, any post-exploitation rules provided by Elastic may be helpful in detecting or understanding a Spring4Shell-related intrusion attempt. For enterprises seeking to better understand this vulnerability, consider [this](https://sholzhauer.medium.com/spring4shell-detection-and-response-elastic-946ec4f59026) excellent overview by Elastic community member Stijn Holzhauer.

## Defensive recommendations

Enterprises should follow guidance provided by Spring in their [official disclosure announcement](https://spring.io/blog/2022/03/31/spring-framework-rce-early-announcement), and seek to patch or upgrade the Spring framework. Additionally, for those who may not be able to address the vulnerability in Spring, a patch has also been released to close this vulnerability in Apache Tomcat (minimum versions 10.0.20, 9.0.62, 8.5.78). Further, it is possible to configure disallowedFields to neutralize vulnerabilities related to data binding abuses.

## References

- [Spring Framework RCE, Early Announcement](https://spring.io/blog/2022/03/31/spring-framework-rce-early-announcement)
- [CVE-2022-22965: Spring Framework RCE via Data Binding on JDK 9+](https://tanzu.vmware.com/security/cve-2022-22965)
- [Using the Elastic stack to detect potential malicious requests and explore exposure to the RCE flaw in the Java Spring Framework.](https://sholzhauer.medium.com/spring4shell-detection-and-response-elastic-946ec4f59026)

**Not already using Elastic Security? You can always get started with a [free 14-day trial](https://cloud.elastic.co/registration) of Elastic Cloud.**
