---
title: "Elastic publishes 2023 Global Threat Report Spring Edition"
slug: "elastic-publishes-2023-global-threat-report-spring-edition"
date: "2023-04-28"
description: "This week, we’re publishing a new version of this report that’s online and interactive, which includes additional data covering the remainder of 2022, written using Elastic technologies."
author:
  - slug: devon-kerr
image: "download_(1).jpg"
category:
  - slug: reports
tags:
  - gtr
---

Last November, Elastic [published](https://www.elastic.co/security-labs/2022-elastic-global-threat-report-announcement) our inaugural global threat report: a summary of threat trends, forecasts, and recommendations based on analyzing millions of telemetry events shared by users around the world. This report is an important part of our continued commitment to transparency, our mission to protect the world's data, as well as a snapshot of our global threat visibility.

This week, we’re publishing a new version of this report that’s [online](https://ela.st/gtr) and interactive, which includes additional data covering the remainder of 2022, written using Elastic. We’d like to offer a few thoughts on this interactive report and share findings both forecasted and unexpected. Let’s take a look at the 2023 Global Threat Report Spring edition!

![Elastic Global Threat Report Spring Edition](/assets/images/elastic-publishes-2023-global-threat-report-spring-edition/image1.png)

First, let’s talk about malware: - We observed consistent trends throughout 2022, with the same approximate ratios of different malware types in all geographies - Trojans, cryptominers, and ransomware held the top spots - Linux and Windows continued to see higher rates of malware than MacOS

Next, consider these cloud observations: - Credential access attempts beat out every other tactic for Microsoft Azure, Google Cloud, and AWS as forecast - Brute force techniques remained steady along with token theft

But there were also a few new findings: - Impairing defenses by tampering with cloud logging functionality was one of the most common techniques we observed in the later part of 2022 and continues into 2023 - This likely impacted visibility of other techniques due to missing data sources, and is potentially a reaction to improvements in cloud logging - XMRig prevalence exploded on MacOS, likely as a result of macroeconomic conditions

As excited as we are to begin work on the _next_ Elastic Global Threat Report and review how well we forecasted 2023, it’s been energizing to close out the 2022 calendar year with a few surprises. Defense evasion is still the top tactic for endpoint, credential access is still king of cloud, and malware trends have stayed pretty consistent. [Check it out](https://ela.st/gtr) yourself and learn a little bit about how Elastic’s Canvas technology simplifies visualization.

If you’re attending RSAC 2023 come visit us at booth #5879, and don’t forget to follow @elasticseclabs on Twitter.
