---
title: "Detection rules for SIGRed vulnerability"
slug: "detection-rules-for-sigred-vulnerability"
date: "2022-11-22"
description: "The SIGRed vulnerability impacts all systems leveraging the Windows DNS server service (Windows 2003+). To defend your environment, we recommend implementing the detection logic included in this blog post using technology like Elastic Security."
author:
  - slug: seth-goodwin
  - slug: daniel-stepanic
  - slug: justin-ibarra
  - slug: andrew-pease
image: "blog-thumb-security-laptop.png"
category:
  - slug: security-research
  - slug: vulnerability-updates
tags:
  - sigred
  - cve-2020-1350
---

> To defend your environment from the SIGRed vulnerability, we recommend implementing the detection logic included below into your environment using technology such as [Endpoint security](https://www.elastic.co/endpoint-security/), [Winlogbeat](https://www.elastic.co/beats/winlogbeat), [Packetbeat](https://www.elastic.co/beats/packetbeat), or [network security monitoring (NSM)](https://www.elastic.co/training/network-security-monitoring-engineer) platforms such as Zeek or Suricata.

## Executive summary

On July 14, 2020, Microsoft released a [security update](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1350) related to a remote code execution (RCE) and denial of service (DoS) vulnerability ([CVE-2020-1350](https://nvd.nist.gov/vuln/detail/CVE-2020-1350)) in Windows DNS Server (2003 - 2019).

### Summary

- National Institute of Standards and Technology (NIST) assigned a critical [CVSS score](https://www.first.org/cvss/v3.1/specification-document)of 10 out of 10 based on remote code execution without authentication and potential to self-replicate without user interaction
- The vulnerability is estimated to be 17 years old and impacts older operating systems (Windows 2003+), which may no longer be supported
- The DNS role, which must be enabled to be impacted, is enabled in most environments, and is required by Active Directory and Kerberos services
- The vulnerability was [reported](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin:-exploiting-a-17-year-old-bug-in-windows-dns-servers/) by Check Point Research and given name “SIGRed”

### Timeline of events

- May 19, 2020 - Initial Check Point disclosure sent to Microsoft
- June 18, 2020 - CVE-2020-1350 issued to vulnerability
- July 14, 2020 - Microsoft released patch
- July 16, 2020 - First public DoS proof-of-concept [published](https://github.com/maxpl0it/CVE-2020-1350-DoS)
- July 17, 2020 - Elastic releases SIGRed public detection logic

## Impact

All systems leveraging the Windows DNS server service are impacted (Windows 2003+). This includes machines such as domain controllers/member servers leveraging Active Directory/Kerberos, as these services rely on the Windows DNS service.

Of note, this is an impact on the way Windows DNS server improperly handles malformed requests and not an underlying issue with the DNS protocol itself.

The SIGRed exploit leverages multiple tactics and techniques categorized by the MITRE ATT&CK® framework:

### Tactics

- [Lateral Movement](https://attack.mitre.org/tactics/TA0008)
- [Execution](https://attack.mitre.org/tactics/TA0002)

### Techniques

- [External Remote Services](https://attack.mitre.org/techniques/T1133)
- [Exploitation of Remote Services](https://attack.mitre.org/techniques/T1210)

## Detection

### Detection logic

On June 30, 2020, The Elastic Security Intelligence & Analytics Team [released](https://www.elastic.co/blog/elastic-security-opens-public-detection-rules-repo) our [Detection Rules Repository](https://github.com/elastic/detection-rules) to the public. Expanding on the rules that were released with that post, we’ve included network and endpoint rules that target CVE-2020-1350 (SIGRed) in the public repository:

- [Unusual Child Process of dns.exe](https://github.com/elastic/detection-rules/blob/main/rules/windows/execution_unusual_dns_service_children.toml)
- [Unusual File Modification by dns.exe](https://github.com/elastic/detection-rules/blob/main/rules/windows/execution_unusual_dns_service_file_writes.toml)
- [Abnormally Large DNS Response](https://github.com/elastic/detection-rules/blob/main/rules/windows/lateral_movement_dns_server_overflow.toml)

### Unusual child of dns.exe - Kibana Query Language (KQL)

The detection logic in Figure 1 (below) identifies suspicious or unexpected child processes spawned from the Windows DNS service (dns.exe). This activity may indicate activity related to remote code execution (RCE) or other forms of exploitation.

```
event.category:process and event.type:start and process.parent.name:dns.exe and not process.name:conhost.exe
```

_Figure 1 - Unusual child process of dns.exe_

### Unusual file operations of dns.exe (KQL)

The detection logic in Figure 2 (below) identifies suspicious or unexpected files being modified by the Windows DNS service (dns.exe). This not only indicates potential RCE or exploitation, but may also indicate preparation for post-compromise activities. For example, this service which is running with SYSTEM privileges could be used to silently write a DLL to Windows system folder setting up possible execution through a known DLL side-loading vector.

```
event.category:file and process.name:dns.exe and not file.name:dns.log
```

_Figure 2 - Unusual file modification by dns.exe_

### Network (Packetbeat and Filebeat with the Zeek or Suricata modules)

As detailed in the [Check Point SIGRed research](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin:-exploiting-a-17-year-old-bug-in-windows-dns-servers/), abnormally large DNS responses can cause the heap-based buffer overflow scenario. The logic in Figure 3 (below) identifies large DNS responses using either Packetbeat or Filebeat (with Zeek or Suricata modules enabled).

```
event.category:(network or network_traffic) and destination.port:53 and (event.dataset:zeek.dns or type:dns or event.type:connection) and network.bytes>60000
```

_Figure 3 - Abnormally large DNS response (KQL)_

![Figure 4 - Packetbeat network detection logic identifying SIGRed - PCAP Source: maxpl0it](/assets/images/detection-rules-for-sigred-vulnerability/packetbeat-network-blog-sigred-vulnerability.png)

![Figure 5 - Filebeat (with Zeek and Suricata) network detection logic identifying SIGRed - PCAP Source: SANS Internet Storm Center](/assets/images/detection-rules-for-sigred-vulnerability/filebeat-network-blog-sigred-vulnerability.png)

## Defensive recommendations

1. Review and [implement](https://www.elastic.co/guide/en/siem/guide/7.8/rules-ui-create.html#create-rule-ui) the above detection logic within your environment using technology such as [Endpoint security](https://www.elastic.co/endpoint-security/), [Winlogbeat](https://www.elastic.co/beats/winlogbeat), [Packetbeat](https://www.elastic.co/beats/packetbeat), or [network security monitoring (NSM)](https://www.elastic.co/training/network-security-monitoring-engineer) platforms such as Zeek or Suricata.
2. Use the included network rule to identify large DNS queries and responses from internal and external populations.
3. Ensure that you have deployed the latest Microsoft [Security Update](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1350) (Monthly Rollup or Security Only) and restart the patched machines. If unable to patch immediately: Microsoft [released](https://support.microsoft.com/en-us/help/4569509/windows-dns-server-remote-code-execution-vulnerability) a registry-based workaround that doesn’t require a restart. This can be used as a temporary solution before the patch is applied.
4. Maintain backups of your critical systems to aid in quick recovery.
5. Perform routine vulnerability scans of your systems and patch identified vulnerabilities.

## References

1. [CVE-2020-1350 | Windows DNS Server Remote Code Execution Vulnerability](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1350)
2. [CVE-2020-1350](https://nvd.nist.gov/vuln/detail/CVE-2020-1350)
3. [SIGRed – Resolving Your Way into Domain Admin: Exploiting a 17 Year-old Bug in Windows DNS Servers](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin:-exploiting-a-17-year-old-bug-in-windows-dns-servers/)
4. [Elastic Security opens public detection rules repo](https://www.elastic.co/blog/elastic-security-opens-public-detection-rules-repo)
5. [Maxpl0it - CVE-2020-1350 (SIGRed) - Windows DNS DoS Exploit](https://github.com/maxpl0it/CVE-2020-1350-DoS)
6. [SANS Internet Storm Center - PATCH NOW - SIGRed - CVE-2020-1350 - Microsoft DNS Server Vulnerability](https://isc.sans.edu/forums/diary/PATCH+NOW+SIGRed+CVE20201350+Microsoft+DNS+Server+Vulnerability/26356/)
