---
title: "Detection and response for the actively exploited ProxyShell vulnerabilities"
slug: "detection-and-response-for-the-actively-exploited-proxyshell-vulnerabilities"
date: "2022-06-02"
description: "In the last week, Elastic Security has observed the exploitation of Microsoft Exchange vulnerabilities associated with ProxyShell. Review the post to find newly released details about this activity."
author:
  - slug: daniel-stepanic
  - slug: andrew-pease
image: "blog-thumb-blind-spots.png"
category:
  - slug: security-research
---

On August 21, 2021, the Cybersecurity and Infrastructure Security Agency (CISA) released an urgent [notice](https://us-cert.cisa.gov/ncas/current-activity/2021/08/21/urgent-protect-against-active-exploitation-proxyshell) related to the exploitation of ProxyShell vulnerabilities ([CVE-2021-31207](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-31207), [CVE-2021-34473](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-34473), [CVE-2021-34523](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-34523)). By chaining these vulnerabilities together, threat actors are compromising unpatched Microsoft Exchange servers and gaining footholds into enterprise networks. [Security vendors](https://symantec-enterprise-blogs.security.com/blogs/threat-intelligence/lockfile-ransomware-new-petitpotam-windows) and [researchers](https://twitter.com/KyleHanslovan/status/1428804893423382532?s=20) are also observing these attacks tied to post-exploitation behavior such as deploying ransomware to victim environments.

Elastic Security identified indicators of compromise (IoCs) indicating similar activity as reported by the industry. The details of this activity can be found in our Discuss forum, highlighting our perspective of what we have observed in our own telemetry.

Please visit the [Discuss forum](https://discuss.elastic.co/t/detection-and-response-for-proxyshell-activity/282407) for full details on our identified IoCs.
