---
title: "Automating the Security Protections rapid response to malware"
slug: "automating-security-protections-rapid-response-to-malware"
date: "2023-03-01"
description: "See how we’ve been improving the processes that allow us to make updates quickly in response to new information and propagate those protections to our users, with the help of machine learning models."
author:
  - slug: samantha-zeitlin
image: "blog-security-endpoint-720x420.png"
category:
  - slug: machine-learning
  - slug: detection-science
---

Cyber attacks on corporate networks were [<u>up 50% in 2021</u>](https://www.forbes.com/sites/chuckbrooks/2022/01/21/cybersecurity-in-2022--a-fresh-look-at-some-very-alarming-stats/?sh=675676ea6b61), and it’s [<u>expected that 2022 will see more of the same</u>](https://www.govtech.com/blogs/lohrmann-on-cybersecurity/the-top-22-security-predictions-for-2022). [<u>Elastic Endpoint Security</u>](https://www.elastic.co/endpoint-security/) includes a variety of protection layers to ensure maximum coverage against different types of malware. There have been a few examples recently of the need for [<u>fast, accurate updates</u>](https://www.elastic.co/blog/elastic-protects-against-data-wiper-malware-targeting-ukraine-hermeticwiper) of user environments in order to protect against the latest malware. Here at Elastic, we’ve been improving the processes that allow us to make updates quickly in response to new information and propagate those protections to our users.

As part of our security solution, we use a machine learning model to help us detect malware based on known characteristics. Since machine learning is never perfect, we deploy supplemental artifacts, including lists of known file hashes that range from malicious to benign. There are two scenarios when we might need to update these lists, which we’ll cover here. Using these, teams can experience a much faster response to malware.

[Related article: [<u>Sandboxing anti-malware products for fun and profit</u>](https://www.elastic.co/blog/sandboxing-anti-malware-products-for-fun-and-profit)]

## Scenario 1: The model isn’t perfect

This happens pretty rarely, since our model has True Negative rates of 99.8%. But no model is perfect, and our True Positive rates vary from 99% (which is great) down to 97.9%, due to noisy data — particularly large bursts of near-duplicates. In applying machine learning to cybersecurity, data drift is an ever-present challenge and part of what makes it such an interesting problem.

There are a couple of ways we can find out if our model is doing the wrong thing:

1. **User feedback.**

A user sends us an email telling us that a piece of custom software is being flagged as malware, but is actually safe.

2. **Telemetry data coming back from our model running on customers’ machines.**

We look at the volume and velocity of alerts, using Elastic’s Anomaly Detection feature to let us know if there is a sudden spike from a particular file. We also use patterns to help us confirm if an alert is coming from a single noisy machine, a test cluster, or a legitimate threat.

The advantage of using lists as a backstop to machine learning is that it’s a fast and easy way to make sure our customers are protected from new malware, as well as protecting them from unnecessary noise from false positives.

## Scenario 2: New forms of malware appear

We typically find out about new kinds of malware from either security news/community resources, or our own Security Intelligence and Analytics team identifying new kinds of malware.

When this happens, we can easily deploy small changes to lists. We update the model separately, because that takes longer.

We’ve been steadily adding more automation to make this process of deploying updated lists to customers smoother and faster, with the goal of making it easy for anyone on the team to create and deploy an update. We’ve also been working on making the process of updating the model easier and faster.

## Threats yet discovered…

The Elastic Security Intelligence and Analytics team continues to research and respond to groundbreaking threats in its mission to help Elastic customers and the broader security community. If you’re using [<u>Elastic Security</u>](https://www.elastic.co/security?utm_source=log4j+hub+blog&utm_medium=embed+link&utm_campaign=log4j_hub_blog&utm_id=log4j&utm_content=elastic+security) already, you can expect to see our latest findings in the newsfeed within the platform. We’ll also post our latest findings on [<u>elastic.co/blog</u>](https://www.elastic.co/blog).

Ready to become part of the Elastic Security community and take advantage of the team’s leading threat research? Get started with a free [<u>14-day trial of Elastic Cloud</u>](https://cloud.elastic.co/registration?utm_source=log4j+hub+blog&utm_medium=embed+link&utm_campaign=log4j_hub_blog&utm_id=log4j&utm_content=trail) or [<u>download</u>](https://www.elastic.co/downloads/?utm_source=log4j+hub+blog&utm_medium=embed+link&utm_campaign=log4j_hub_blog&utm_id=log4j&utm_content=download) the self-managed version of the Elastic Stack for free.
