"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformESToKnowledgeBase = exports.transformESSearchToKnowledgeBaseEntry = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESSearchToKnowledgeBaseEntry = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const kbEntrySchema = hit._source;
    return {
      ...transformEsSchemaToEntry(kbEntrySchema),
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id
    };
  });
};
exports.transformESSearchToKnowledgeBaseEntry = transformESSearchToKnowledgeBaseEntry;
const transformESToKnowledgeBase = response => {
  return response.map(kbEntrySchema => {
    return transformEsSchemaToEntry(kbEntrySchema);
  });
};
exports.transformESToKnowledgeBase = transformESToKnowledgeBase;
const transformEsSchemaToEntry = esKbEntry => {
  if (esKbEntry.type === _elasticAssistantCommon.DocumentEntryType.value) {
    var _esKbEntry$users$map, _esKbEntry$users;
    const documentEntry = {
      id: esKbEntry.id,
      createdAt: esKbEntry.created_at,
      createdBy: esKbEntry.created_by,
      updatedAt: esKbEntry.updated_at,
      updatedBy: esKbEntry.updated_by,
      users: (_esKbEntry$users$map = (_esKbEntry$users = esKbEntry.users) === null || _esKbEntry$users === void 0 ? void 0 : _esKbEntry$users.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _esKbEntry$users$map !== void 0 ? _esKbEntry$users$map : [],
      name: esKbEntry.name,
      namespace: esKbEntry.namespace,
      type: esKbEntry.type,
      kbResource: esKbEntry.kb_resource,
      source: esKbEntry.source,
      required: esKbEntry.required,
      text: esKbEntry.text,
      ...(esKbEntry.vector ? {
        vector: {
          modelId: esKbEntry.vector.model_id,
          tokens: esKbEntry.vector.tokens
        }
      } : {})
    };
    return documentEntry;
  } else if (esKbEntry.type === _elasticAssistantCommon.IndexEntryType.value) {
    var _esKbEntry$users$map2, _esKbEntry$users2, _esKbEntry$input_sche, _esKbEntry$input_sche2, _esKbEntry$output_fie;
    const indexEntry = {
      id: esKbEntry.id,
      createdAt: esKbEntry.created_at,
      createdBy: esKbEntry.created_by,
      updatedAt: esKbEntry.updated_at,
      updatedBy: esKbEntry.updated_by,
      users: (_esKbEntry$users$map2 = (_esKbEntry$users2 = esKbEntry.users) === null || _esKbEntry$users2 === void 0 ? void 0 : _esKbEntry$users2.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _esKbEntry$users$map2 !== void 0 ? _esKbEntry$users$map2 : [],
      name: esKbEntry.name,
      namespace: esKbEntry.namespace,
      // Document Entry Fields
      type: esKbEntry.type,
      index: esKbEntry.index,
      field: esKbEntry.field,
      description: esKbEntry.description,
      queryDescription: esKbEntry.query_description,
      inputSchema: (_esKbEntry$input_sche = (_esKbEntry$input_sche2 = esKbEntry.input_schema) === null || _esKbEntry$input_sche2 === void 0 ? void 0 : _esKbEntry$input_sche2.map(schema => ({
        fieldName: schema.field_name,
        fieldType: schema.field_type,
        description: schema.description
      }))) !== null && _esKbEntry$input_sche !== void 0 ? _esKbEntry$input_sche : [],
      outputFields: (_esKbEntry$output_fie = esKbEntry.output_fields) !== null && _esKbEntry$output_fie !== void 0 ? _esKbEntry$output_fie : []
    };
    return indexEntry;
  }

  // Parse Legacy KB Entry as a DocumentEntry
  return getDocumentEntryFromLegacyKbEntry(esKbEntry);
};
const getDocumentEntryFromLegacyKbEntry = legacyEsKbDoc => {
  var _legacyEsKbDoc$users$, _legacyEsKbDoc$users, _legacyEsKbDoc$metada, _legacyEsKbDoc$metada2, _legacyEsKbDoc$metada3, _legacyEsKbDoc$metada4, _legacyEsKbDoc$metada5, _legacyEsKbDoc$metada6;
  const documentEntry = {
    id: legacyEsKbDoc.id,
    createdAt: legacyEsKbDoc.created_at,
    createdBy: legacyEsKbDoc.created_by,
    updatedAt: legacyEsKbDoc.updated_at,
    updatedBy: legacyEsKbDoc.updated_by,
    users: (_legacyEsKbDoc$users$ = (_legacyEsKbDoc$users = legacyEsKbDoc.users) === null || _legacyEsKbDoc$users === void 0 ? void 0 : _legacyEsKbDoc$users.map(user => ({
      id: user.id,
      name: user.name
    }))) !== null && _legacyEsKbDoc$users$ !== void 0 ? _legacyEsKbDoc$users$ : [],
    name: legacyEsKbDoc.text,
    namespace: legacyEsKbDoc.namespace,
    type: _elasticAssistantCommon.DocumentEntryType.value,
    kbResource: (_legacyEsKbDoc$metada = (_legacyEsKbDoc$metada2 = legacyEsKbDoc.metadata) === null || _legacyEsKbDoc$metada2 === void 0 ? void 0 : _legacyEsKbDoc$metada2.kbResource) !== null && _legacyEsKbDoc$metada !== void 0 ? _legacyEsKbDoc$metada : 'unknown',
    source: (_legacyEsKbDoc$metada3 = (_legacyEsKbDoc$metada4 = legacyEsKbDoc.metadata) === null || _legacyEsKbDoc$metada4 === void 0 ? void 0 : _legacyEsKbDoc$metada4.source) !== null && _legacyEsKbDoc$metada3 !== void 0 ? _legacyEsKbDoc$metada3 : 'unknown',
    required: (_legacyEsKbDoc$metada5 = (_legacyEsKbDoc$metada6 = legacyEsKbDoc.metadata) === null || _legacyEsKbDoc$metada6 === void 0 ? void 0 : _legacyEsKbDoc$metada6.required) !== null && _legacyEsKbDoc$metada5 !== void 0 ? _legacyEsKbDoc$metada5 : false,
    text: legacyEsKbDoc.text,
    ...(legacyEsKbDoc.vector ? {
      vector: {
        modelId: legacyEsKbDoc.vector.model_id,
        tokens: legacyEsKbDoc.vector.tokens
      }
    } : {})
  };
  return documentEntry;
};