"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.knowledgeBaseIngestPipeline = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const knowledgeBaseIngestPipeline = ({
  id,
  modelId,
  v2KnowledgeBaseEnabled
}) => ({
  id,
  description: 'Embedding pipeline for Elastic AI Assistant ELSER Knowledge Base',
  processors: !v2KnowledgeBaseEnabled ? [{
    inference: {
      if: 'ctx?.text != null',
      model_id: modelId,
      input_output: [{
        input_field: 'text',
        output_field: 'vector.tokens'
      }]
    }
  }] : []
});
exports.knowledgeBaseIngestPipeline = knowledgeBaseIngestPipeline;