"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformESToConversations = exports.transformESSearchToConversations = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESSearchToConversations = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    var _conversationSchema$u, _conversationSchema$u2, _conversationSchema$m, _conversationSchema$m2, _conversationSchema$r2;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const conversationSchema = hit._source;
    const conversation = {
      timestamp: conversationSchema['@timestamp'],
      createdAt: conversationSchema.created_at,
      users: (_conversationSchema$u = (_conversationSchema$u2 = conversationSchema.users) === null || _conversationSchema$u2 === void 0 ? void 0 : _conversationSchema$u2.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _conversationSchema$u !== void 0 ? _conversationSchema$u : [],
      title: conversationSchema.title,
      category: conversationSchema.category,
      summary: conversationSchema.summary,
      ...(conversationSchema.api_config ? {
        apiConfig: {
          connectorId: conversationSchema.api_config.connector_id,
          actionTypeId: conversationSchema.api_config.action_type_id,
          defaultSystemPromptId: conversationSchema.api_config.default_system_prompt_id,
          model: conversationSchema.api_config.model,
          provider: conversationSchema.api_config.provider
        }
      } : {}),
      excludeFromLastConversationStorage: conversationSchema.exclude_from_last_conversation_storage,
      isDefault: conversationSchema.is_default,
      messages: // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (_conversationSchema$m = (_conversationSchema$m2 = conversationSchema.messages) === null || _conversationSchema$m2 === void 0 ? void 0 : _conversationSchema$m2.map(message => {
        var _conversationSchema$r, _message$trace_data, _message$trace_data2;
        return {
          timestamp: message['@timestamp'],
          // always return anonymized data from the client
          content: conversationSchema.replacements ? (0, _elasticAssistantCommon.replaceOriginalValuesWithUuidValues)({
            messageContent: message.content,
            replacements: (_conversationSchema$r = conversationSchema.replacements) === null || _conversationSchema$r === void 0 ? void 0 : _conversationSchema$r.reduce((acc, r) => {
              acc[r.uuid] = r.value;
              return acc;
            }, {})
          }) : message.content,
          ...(message.is_error ? {
            isError: message.is_error
          } : {}),
          ...(message.reader ? {
            reader: message.reader
          } : {}),
          role: message.role,
          ...(message.trace_data ? {
            traceData: {
              traceId: (_message$trace_data = message.trace_data) === null || _message$trace_data === void 0 ? void 0 : _message$trace_data.trace_id,
              transactionId: (_message$trace_data2 = message.trace_data) === null || _message$trace_data2 === void 0 ? void 0 : _message$trace_data2.transaction_id
            }
          } : {})
        };
      })) !== null && _conversationSchema$m !== void 0 ? _conversationSchema$m : [],
      updatedAt: conversationSchema.updated_at,
      replacements: (_conversationSchema$r2 = conversationSchema.replacements) === null || _conversationSchema$r2 === void 0 ? void 0 : _conversationSchema$r2.reduce((acc, r) => {
        acc[r.uuid] = r.value;
        return acc;
      }, {}),
      namespace: conversationSchema.namespace,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id
    };
    return conversation;
  });
};
exports.transformESSearchToConversations = transformESSearchToConversations;
const transformESToConversations = response => {
  return response.map(conversationSchema => {
    var _conversationSchema$r3, _conversationSchema$u3, _conversationSchema$u4, _conversationSchema$m3, _conversationSchema$m4;
    const replacements = (_conversationSchema$r3 = conversationSchema.replacements) === null || _conversationSchema$r3 === void 0 ? void 0 : _conversationSchema$r3.reduce((acc, r) => {
      acc[r.uuid] = r.value;
      return acc;
    }, {});
    const conversation = {
      timestamp: conversationSchema['@timestamp'],
      createdAt: conversationSchema.created_at,
      users: (_conversationSchema$u3 = (_conversationSchema$u4 = conversationSchema.users) === null || _conversationSchema$u4 === void 0 ? void 0 : _conversationSchema$u4.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _conversationSchema$u3 !== void 0 ? _conversationSchema$u3 : [],
      title: conversationSchema.title,
      category: conversationSchema.category,
      summary: conversationSchema.summary,
      ...(conversationSchema.api_config ? {
        apiConfig: {
          actionTypeId: conversationSchema.api_config.action_type_id,
          connectorId: conversationSchema.api_config.connector_id,
          defaultSystemPromptId: conversationSchema.api_config.default_system_prompt_id,
          model: conversationSchema.api_config.model,
          provider: conversationSchema.api_config.provider
        }
      } : {}),
      excludeFromLastConversationStorage: conversationSchema.exclude_from_last_conversation_storage,
      isDefault: conversationSchema.is_default,
      messages: // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (_conversationSchema$m3 = (_conversationSchema$m4 = conversationSchema.messages) === null || _conversationSchema$m4 === void 0 ? void 0 : _conversationSchema$m4.map(message => {
        var _message$trace_data3, _message$trace_data4;
        return {
          timestamp: message['@timestamp'],
          // always return anonymized data from the client
          content: (0, _elasticAssistantCommon.replaceOriginalValuesWithUuidValues)({
            messageContent: message.content,
            replacements
          }),
          ...(message.is_error ? {
            isError: message.is_error
          } : {}),
          ...(message.reader ? {
            reader: message.reader
          } : {}),
          role: message.role,
          ...(message.trace_data ? {
            traceData: {
              traceId: (_message$trace_data3 = message.trace_data) === null || _message$trace_data3 === void 0 ? void 0 : _message$trace_data3.trace_id,
              transactionId: (_message$trace_data4 = message.trace_data) === null || _message$trace_data4 === void 0 ? void 0 : _message$trace_data4.transaction_id
            }
          } : {})
        };
      })) !== null && _conversationSchema$m3 !== void 0 ? _conversationSchema$m3 : [],
      updatedAt: conversationSchema.updated_at,
      replacements,
      namespace: conversationSchema.namespace,
      id: conversationSchema.id
    };
    return conversation;
  });
};
exports.transformESToConversations = transformESToConversations;