"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceData = exports.Replacements = exports.Reader = exports.ProviderEnum = exports.Provider = exports.MessageRoleEnum = exports.MessageRole = exports.Message = exports.ErrorSchema = exports.ConversationUpdateProps = exports.ConversationSummary = exports.ConversationResponse = exports.ConversationMessageCreateProps = exports.ConversationCreateProps = exports.ConversationConfidenceEnum = exports.ConversationConfidence = exports.ConversationCategoryEnum = exports.ConversationCategory = exports.ApiConfig = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Conversation Attributes
 *   version: not applicable
 */

/**
 * trace Data
 */

const TraceData = exports.TraceData = _zod.z.object({
  /**
   * Could be any string, not necessarily a UUID
   */
  transactionId: _zod.z.string().optional(),
  /**
   * Could be any string, not necessarily a UUID
   */
  traceId: _zod.z.string().optional()
});

/**
 * Replacements object used to anonymize/deanomymize messsages
 */

const Replacements = exports.Replacements = _zod.z.object({}).catchall(_zod.z.string());
const Reader = exports.Reader = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Provider
 */

const Provider = exports.Provider = _zod.z.enum(['OpenAI', 'Azure OpenAI', 'Other']);
const ProviderEnum = exports.ProviderEnum = Provider.enum;

/**
 * Message role.
 */

const MessageRole = exports.MessageRole = _zod.z.enum(['system', 'user', 'assistant']);
const MessageRoleEnum = exports.MessageRoleEnum = MessageRole.enum;

/**
 * The conversation category.
 */

const ConversationCategory = exports.ConversationCategory = _zod.z.enum(['assistant', 'insights']);
const ConversationCategoryEnum = exports.ConversationCategoryEnum = ConversationCategory.enum;

/**
 * The conversation confidence.
 */

const ConversationConfidence = exports.ConversationConfidence = _zod.z.enum(['low', 'medium', 'high']);
const ConversationConfidenceEnum = exports.ConversationConfidenceEnum = ConversationConfidence.enum;

/**
 * AI assistant conversation message.
 */

const Message = exports.Message = _zod.z.object({
  /**
   * Message content.
   */
  content: _zod.z.string(),
  /**
   * Message content.
   */
  reader: Reader.optional(),
  /**
   * Message role.
   */
  role: MessageRole,
  /**
   * The timestamp message was sent or received.
   */
  timestamp: _common_attributes.NonEmptyString,
  /**
   * Is error message.
   */
  isError: _zod.z.boolean().optional(),
  /**
   * trace Data
   */
  traceData: TraceData.optional()
});
const ApiConfig = exports.ApiConfig = _zod.z.object({
  /**
   * connector id
   */
  connectorId: _zod.z.string(),
  /**
   * action type id
   */
  actionTypeId: _zod.z.string(),
  /**
   * defaultSystemPromptId
   */
  defaultSystemPromptId: _zod.z.string().optional(),
  /**
   * Provider
   */
  provider: Provider.optional(),
  /**
   * model
   */
  model: _zod.z.string().optional()
});
const ConversationSummary = exports.ConversationSummary = _zod.z.object({
  /**
   * Summary text of the conversation over time.
   */
  content: _zod.z.string().optional(),
  /**
   * The timestamp summary was updated.
   */
  timestamp: _common_attributes.NonEmptyString.optional(),
  /**
   * Define if summary is marked as publicly available.
   */
  public: _zod.z.boolean().optional(),
  /**
   * How confident you are about this being a correct and useful learning.
   */
  confidence: ConversationConfidence.optional()
});
const ErrorSchema = exports.ErrorSchema = _zod.z.object({
  id: _common_attributes.NonEmptyString.optional(),
  error: _zod.z.object({
    status_code: _zod.z.number().int().min(400),
    message: _zod.z.string()
  })
}).strict();
const ConversationResponse = exports.ConversationResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory,
  summary: ConversationSummary.optional(),
  timestamp: _common_attributes.NonEmptyString.optional(),
  /**
   * The last time conversation was updated.
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * The last time conversation was updated.
   */
  createdAt: _zod.z.string(),
  replacements: Replacements.optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Is default conversation.
   */
  isDefault: _zod.z.boolean().optional(),
  /**
   * excludeFromLastConversationStorage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string()
});
const ConversationUpdateProps = exports.ConversationUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string().optional(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  summary: ConversationSummary.optional(),
  /**
   * excludeFromLastConversationStorage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional()
});
const ConversationCreateProps = exports.ConversationCreateProps = _zod.z.object({
  /**
   * The conversation id.
   */
  id: _zod.z.string().optional(),
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Is default conversation.
   */
  isDefault: _zod.z.boolean().optional(),
  /**
   * excludeFromLastConversationStorage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional()
});
const ConversationMessageCreateProps = exports.ConversationMessageCreateProps = _zod.z.object({
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message)
});