"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.User = exports.UUID = exports.SortOrderEnum = exports.SortOrder = exports.NonEmptyString = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Elastic AI Assistant Attributes
 *   version: not applicable
 */

/**
 * A string that does not contain only whitespace characters
 */

const NonEmptyString = exports.NonEmptyString = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * A universally unique identifier
 */

const UUID = exports.UUID = _zod.z.string().uuid();

/**
 * Could be any string, not necessarily a UUID
 */

const User = exports.User = _zod.z.object({
  /**
   * User id
   */
  id: _zod.z.string().optional(),
  /**
   * User name
   */
  name: _zod.z.string().optional()
});
const SortOrder = exports.SortOrder = _zod.z.enum(['asc', 'desc']);
const SortOrderEnum = exports.SortOrderEnum = SortOrder.enum;