"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStacktraceFields = void 0;
var _ = require("..");
var _field_constants = require("../field_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStacktraceFields = doc => {
  const errorStackTrace = (0, _.getFieldValue)(doc, _field_constants.ERROR_STACK_TRACE);
  const errorExceptionStackTrace = (0, _.getFieldValue)(doc, _field_constants.ERROR_EXCEPTION_STACKTRACE);
  const errorLogStackTrace = (0, _.getFieldValue)(doc, _field_constants.ERROR_LOG_STACKTRACE);
  return {
    [_field_constants.ERROR_STACK_TRACE]: errorStackTrace,
    [_field_constants.ERROR_EXCEPTION_STACKTRACE]: errorExceptionStackTrace,
    [_field_constants.ERROR_LOG_STACKTRACE]: errorLogStackTrace
  };
};
exports.getStacktraceFields = getStacktraceFields;