"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageFieldWithFallbacks = void 0;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getMessageFieldWithFallbacks = doc => {
  const rankingOrder = [_.fieldConstants.MESSAGE_FIELD, _.fieldConstants.ERROR_MESSAGE_FIELD, _.fieldConstants.EVENT_ORIGINAL_FIELD];
  for (const rank of rankingOrder) {
    if (doc[rank] !== undefined && doc[rank] !== null) {
      return {
        field: rank,
        value: doc[rank]
      };
    }
  }

  // If none of the ranks (fallbacks) are present
  return {
    field: undefined
  };
};
exports.getMessageFieldWithFallbacks = getMessageFieldWithFallbacks;