"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogDocumentOverview = getLogDocumentOverview;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getLogDocumentOverview(doc, {
  dataView,
  fieldFormats
}) {
  const formatField = field => {
    return doc.flattened[field] !== undefined && doc.flattened[field] !== null ? (0, _.formatFieldValue)(doc.flattened[field], doc.raw, fieldFormats, dataView, dataView.fields.getByName(field)) : undefined;
  };
  const levelArray = doc.flattened[_.fieldConstants.LOG_LEVEL_FIELD];
  const level = Array.isArray(levelArray) && levelArray.length ? levelArray[0].toLowerCase() : levelArray;
  const message = formatField(_.fieldConstants.MESSAGE_FIELD);
  const errorMessage = formatField(_.fieldConstants.ERROR_MESSAGE_FIELD);
  const eventOriginal = formatField(_.fieldConstants.EVENT_ORIGINAL_FIELD);
  const timestamp = formatField(_.fieldConstants.TIMESTAMP_FIELD);

  // Service
  const serviceName = formatField(_.fieldConstants.SERVICE_NAME_FIELD);
  const traceId = formatField(_.fieldConstants.TRACE_ID_FIELD);

  // Infrastructure
  const hostname = formatField(_.fieldConstants.HOST_NAME_FIELD);
  const orchestratorClusterName = formatField(_.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD);
  const orchestratorResourceId = formatField(_.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD);

  // Cloud
  const cloudProvider = formatField(_.fieldConstants.CLOUD_PROVIDER_FIELD);
  const cloudRegion = formatField(_.fieldConstants.CLOUD_REGION_FIELD);
  const cloudAz = formatField(_.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD);
  const cloudProjectId = formatField(_.fieldConstants.CLOUD_PROJECT_ID_FIELD);
  const cloudInstanceId = formatField(_.fieldConstants.CLOUD_INSTANCE_ID_FIELD);

  // Other
  const logFilePath = formatField(_.fieldConstants.LOG_FILE_PATH_FIELD);
  const namespace = formatField(_.fieldConstants.DATASTREAM_NAMESPACE_FIELD);
  const dataset = formatField(_.fieldConstants.DATASTREAM_DATASET_FIELD);
  const agentName = formatField(_.fieldConstants.AGENT_NAME_FIELD);
  return {
    [_.fieldConstants.LOG_LEVEL_FIELD]: level,
    [_.fieldConstants.TIMESTAMP_FIELD]: timestamp,
    [_.fieldConstants.MESSAGE_FIELD]: message,
    [_.fieldConstants.ERROR_MESSAGE_FIELD]: errorMessage,
    [_.fieldConstants.EVENT_ORIGINAL_FIELD]: eventOriginal,
    [_.fieldConstants.SERVICE_NAME_FIELD]: serviceName,
    [_.fieldConstants.TRACE_ID_FIELD]: traceId,
    [_.fieldConstants.HOST_NAME_FIELD]: hostname,
    [_.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: orchestratorClusterName,
    [_.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD]: orchestratorResourceId,
    [_.fieldConstants.CLOUD_PROVIDER_FIELD]: cloudProvider,
    [_.fieldConstants.CLOUD_REGION_FIELD]: cloudRegion,
    [_.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD]: cloudAz,
    [_.fieldConstants.CLOUD_PROJECT_ID_FIELD]: cloudProjectId,
    [_.fieldConstants.CLOUD_INSTANCE_ID_FIELD]: cloudInstanceId,
    [_.fieldConstants.LOG_FILE_PATH_FIELD]: logFilePath,
    [_.fieldConstants.DATASTREAM_NAMESPACE_FIELD]: namespace,
    [_.fieldConstants.DATASTREAM_DATASET_FIELD]: dataset,
    [_.fieldConstants.AGENT_NAME_FIELD]: agentName
  };
}