"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dismissFlyouts = exports.dismissAllFlyoutsExceptFor = exports.DiscoverFlyouts = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let DiscoverFlyouts = exports.DiscoverFlyouts = /*#__PURE__*/function (DiscoverFlyouts) {
  DiscoverFlyouts["lensEdit"] = "lensEdit";
  DiscoverFlyouts["docViewer"] = "docViewer";
  DiscoverFlyouts["esqlDocs"] = "esqlDocs";
  return DiscoverFlyouts;
}({});
const AllDiscoverFlyouts = Object.values(DiscoverFlyouts);
const getFlyoutCloseButton = flyout => {
  switch (flyout) {
    case DiscoverFlyouts.lensEdit:
      return document.getElementById('lnsCancelEditOnFlyFlyout');
    case DiscoverFlyouts.docViewer:
      return document.querySelector('[data-test-subj="docViewerFlyoutCloseButton"]');
    case DiscoverFlyouts.esqlDocs:
      return document.querySelector('[data-test-subj="esqlInlineDocumentationFlyout"] [data-test-subj="euiFlyoutCloseButton"]');
  }
};
const dismissFlyouts = (selectedFlyouts = AllDiscoverFlyouts, excludedFlyout) => {
  selectedFlyouts.forEach(flyout => {
    if (flyout === excludedFlyout) {
      return;
    }
    const closeButton = getFlyoutCloseButton(flyout);
    if (closeButton) {
      var _closeButton$click;
      (_closeButton$click = closeButton.click) === null || _closeButton$click === void 0 ? void 0 : _closeButton$click.call(closeButton);
    }
  });
};
exports.dismissFlyouts = dismissFlyouts;
const dismissAllFlyoutsExceptFor = excludedFlyout => {
  dismissFlyouts(AllDiscoverFlyouts, excludedFlyout);
};
exports.dismissAllFlyoutsExceptFor = dismissAllFlyoutsExceptFor;