"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogLevelColor = void 0;
var _eui = require("@elastic/eui");
var _get_log_level_coalesed_value = require("./get_log_level_coalesed_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLogLevelColor = (logLevelCoalescedValue, euiTheme) => {
  const euiPaletteForTemperature6 = (0, _eui.euiPaletteForTemperature)(6);
  const euiPaletteForStatus9 = (0, _eui.euiPaletteForStatus)(9);
  switch (logLevelCoalescedValue) {
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.debug:
      return euiPaletteForTemperature6[2];
    // lighter, closer to the default color for all other unknown log levels
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.info:
      return euiPaletteForTemperature6[1];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.notice:
      return euiPaletteForTemperature6[0];
    // darker as it has higher importance than "debug" and "info"
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.warning:
      return euiPaletteForStatus9[4];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.error:
      return euiPaletteForStatus9[5];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.critical:
      return euiPaletteForStatus9[6];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.alert:
      return euiPaletteForStatus9[7];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.emergency:
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.fatal:
      return euiPaletteForStatus9[8];
    default:
      return euiTheme.colors.lightShade;
  }
};
exports.getLogLevelColor = getLogLevelColor;