"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevelBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const badgeCss = {
  maxWidth: (0, _eui.mathWithUnits)(_uiTheme.euiThemeVars.euiSize, size => size * 7.5)
};
const LogLevelBadge = ({
  logLevel,
  fallback,
  'data-test-subj': dataTestSubj = 'logLevelBadge',
  ...badgeProps
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const coalescedValue = (0, _utils.getLogLevelCoalescedValue)(logLevel);
  const color = coalescedValue ? (0, _utils.getLogLevelColor)(coalescedValue, euiTheme) : undefined;
  const castedBadgeProps = badgeProps;
  if (!color || !coalescedValue) {
    return fallback ? fallback : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, castedBadgeProps, {
      color: "hollow",
      "data-test-subj": `${dataTestSubj}-unknown`,
      css: badgeCss
    }), logLevel);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, castedBadgeProps, {
    color: color,
    "data-test-subj": `${dataTestSubj}-${coalescedValue}`,
    css: badgeCss
  }), logLevel);
};
exports.LogLevelBadge = LogLevelBadge;