"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchEmbeddableFactory = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _cellActions = require("@kbn/cell-actions");
var _public = require("@kbn/data-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("@kbn/saved-search-plugin/common");
var _get_valid_view_mode = require("../application/main/utils/get_valid_view_mode");
var _search_embeddable_field_stats_table_component = require("./components/search_embeddable_field_stats_table_component");
var _search_embeddable_grid_component = require("./components/search_embeddable_grid_component");
var _initialize_edit_api = require("./initialize_edit_api");
var _initialize_fetch = require("./initialize_fetch");
var _initialize_search_embeddable_api = require("./initialize_search_embeddable_api");
var _serialization_utils = require("./utils/serialization_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSearchEmbeddableFactory = ({
  startServices,
  discoverServices
}) => {
  const {
    save,
    checkForDuplicateTitle
  } = discoverServices.savedSearch;
  const savedSearchEmbeddableFactory = {
    type: _discoverUtils.SEARCH_EMBEDDABLE_TYPE,
    deserializeState: async serializedState => {
      return (0, _serialization_utils.deserializeState)({
        serializedState,
        discoverServices
      });
    },
    buildEmbeddable: async (initialState, buildApi, uuid, parentApi) => {
      /** One Discover context awareness */
      const solutionNavId = await (0, _rxjs.firstValueFrom)(discoverServices.core.chrome.getActiveSolutionNavId$());
      await discoverServices.profilesManager.resolveRootProfile({
        solutionNavId
      });

      /** Specific by-reference state */
      const savedObjectId$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectId);
      const defaultPanelTitle$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectTitle);
      const defaultPanelDescription$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectDescription);

      /** All other state */
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const fetchContext$ = new _rxjs.BehaviorSubject(undefined);
      const fetchWarnings$ = new _rxjs.BehaviorSubject([]);

      /** Build API */
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(initialState);
      const timeRange = (0, _presentationPublishing.initializeTimeRange)(initialState);
      const searchEmbeddable = await (0, _initialize_search_embeddable_api.initializeSearchEmbeddableApi)(initialState, {
        discoverServices
      });
      const unsubscribeFromFetch = (0, _initialize_fetch.initializeFetch)({
        api: {
          parentApi,
          ...titlesApi,
          ...timeRange.api,
          savedSearch$: searchEmbeddable.api.savedSearch$,
          dataViews: searchEmbeddable.api.dataViews,
          savedObjectId: savedObjectId$,
          dataLoading: dataLoading$,
          blockingError: blockingError$,
          fetchContext$,
          fetchWarnings$
        },
        discoverServices,
        stateManager: searchEmbeddable.stateManager
      });
      const api = buildApi({
        ...titlesApi,
        ...searchEmbeddable.api,
        ...timeRange.api,
        ...(0, _initialize_edit_api.initializeEditApi)({
          uuid,
          parentApi,
          partialApi: {
            ...searchEmbeddable.api,
            fetchContext$,
            savedObjectId: savedObjectId$
          },
          discoverServices,
          isEditable: startServices.isEditable
        }),
        dataLoading: dataLoading$,
        blockingError: blockingError$,
        savedObjectId: savedObjectId$,
        defaultPanelTitle: defaultPanelTitle$,
        defaultPanelDescription: defaultPanelDescription$,
        getByValueRuntimeSnapshot: () => {
          const savedSearch = searchEmbeddable.api.savedSearch$.getValue();
          return {
            ...serializeTitles(),
            ...timeRange.serialize(),
            ...(0, _lodash.omit)(savedSearch, 'searchSource'),
            serializedSearchSource: savedSearch.searchSource.getSerializedFields()
          };
        },
        hasTimeRange: () => {
          const fetchContext = fetchContext$.getValue();
          return (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeslice) !== undefined || (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeRange) !== undefined;
        },
        getTypeDisplayName: () => _i18n.i18n.translate('discover.embeddable.search.displayName', {
          defaultMessage: 'search'
        }),
        canLinkToLibrary: async () => {
          return discoverServices.capabilities.discover.save && !Boolean(savedObjectId$.getValue());
        },
        canUnlinkFromLibrary: async () => Boolean(savedObjectId$.getValue()),
        libraryId$: savedObjectId$,
        saveToLibrary: async title => {
          const savedObjectId = await save({
            ...api.savedSearch$.getValue(),
            title
          });
          defaultPanelTitle$.next(title);
          savedObjectId$.next(savedObjectId);
          return savedObjectId;
        },
        checkForDuplicateTitle: (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => checkForDuplicateTitle({
          newTitle,
          isTitleDuplicateConfirmed,
          onTitleDuplicate
        }),
        unlinkFromLibrary: () => {
          var _titlesApi$panelTitle, _titlesApi$panelDescr;
          savedObjectId$.next(undefined);
          if (((_titlesApi$panelTitle = titlesApi.panelTitle.getValue()) !== null && _titlesApi$panelTitle !== void 0 ? _titlesApi$panelTitle : '').length === 0) {
            titlesApi.setPanelTitle(defaultPanelTitle$.getValue());
          }
          if (((_titlesApi$panelDescr = titlesApi.panelDescription.getValue()) !== null && _titlesApi$panelDescr !== void 0 ? _titlesApi$panelDescr : '').length === 0) {
            titlesApi.setPanelDescription(defaultPanelDescription$.getValue());
          }
          defaultPanelTitle$.next(undefined);
          defaultPanelDescription$.next(undefined);
        },
        serializeState: async () => (0, _serialization_utils.serializeState)({
          uuid,
          initialState,
          savedSearch: searchEmbeddable.api.savedSearch$.getValue(),
          serializeTitles,
          serializeTimeRange: timeRange.serialize,
          savedObjectId: savedObjectId$.getValue(),
          discoverServices
        }),
        getInspectorAdapters: () => searchEmbeddable.stateManager.inspectorAdapters.getValue()
      }, {
        ...titleComparators,
        ...timeRange.comparators,
        ...searchEmbeddable.comparators,
        savedObjectId: [savedObjectId$, value => savedObjectId$.next(value)],
        savedObjectTitle: [defaultPanelTitle$, value => defaultPanelTitle$.next(value)],
        savedObjectDescription: [defaultPanelDescription$, value => defaultPanelDescription$.next(value)]
      });
      return {
        api,
        Component: () => {
          const [savedSearch, dataViews] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.savedSearch$, api.dataViews);
          (0, _react.useEffect)(() => {
            return () => {
              searchEmbeddable.cleanup();
              unsubscribeFromFetch();
            };
          }, []);
          const viewMode = (0, _react.useMemo)(() => {
            if (!savedSearch.searchSource) return;
            return (0, _get_valid_view_mode.getValidViewMode)({
              viewMode: savedSearch.viewMode,
              isEsqlMode: (0, _initialize_fetch.isEsqlMode)(savedSearch)
            });
          }, [savedSearch]);
          const dataView = (0, _react.useMemo)(() => {
            const hasDataView = (dataViews !== null && dataViews !== void 0 ? dataViews : []).length > 0;
            if (!hasDataView) {
              var _initialState$seriali, _initialState$seriali2, _initialState$seriali3, _initialState$seriali4;
              blockingError$.next(new Error(_i18n.i18n.translate('discover.embeddable.search.dataViewError', {
                defaultMessage: 'Missing data view {indexPatternId}',
                values: {
                  indexPatternId: typeof ((_initialState$seriali = initialState.serializedSearchSource) === null || _initialState$seriali === void 0 ? void 0 : _initialState$seriali.index) === 'string' ? initialState.serializedSearchSource.index : (_initialState$seriali2 = (_initialState$seriali3 = initialState.serializedSearchSource) === null || _initialState$seriali3 === void 0 ? void 0 : (_initialState$seriali4 = _initialState$seriali3.index) === null || _initialState$seriali4 === void 0 ? void 0 : _initialState$seriali4.id) !== null && _initialState$seriali2 !== void 0 ? _initialState$seriali2 : ''
                }
              })));
              return;
            }
            return dataViews[0];
          }, [dataViews]);
          const onAddFilter = (0, _react.useCallback)(async (field, value, operator) => {
            if (!dataView || !field) return;
            let newFilters = (0, _public.generateFilters)(discoverServices.filterManager, field, value, operator, dataView);
            newFilters = newFilters.map(filter => ({
              ...filter,
              $state: {
                store: _esQuery.FilterStateStore.APP_STATE
              }
            }));
            await startServices.executeTriggerActions(_public.APPLY_FILTER_TRIGGER, {
              embeddable: api,
              filters: newFilters
            });
          }, [dataView]);
          const renderAsFieldStatsTable = (0, _react.useMemo)(() => Boolean(discoverServices.uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) && viewMode === _common.VIEW_MODE.AGGREGATED_LEVEL && Boolean(dataView) && Array.isArray(savedSearch.columns), [savedSearch, dataView, viewMode]);
          return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, discoverServices.core, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
            services: discoverServices
          }, renderAsFieldStatsTable ? /*#__PURE__*/_react.default.createElement(_search_embeddable_field_stats_table_component.SearchEmbeddablFieldStatsTableComponent, {
            api: {
              ...api,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) ? undefined : onAddFilter,
            stateManager: searchEmbeddable.stateManager
          }) : /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
            getTriggerCompatibleActions: discoverServices.uiActions.getTriggerCompatibleActions
          }, /*#__PURE__*/_react.default.createElement(_search_embeddable_grid_component.SearchEmbeddableGridComponent, {
            api: {
              ...api,
              fetchWarnings$,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) ? undefined : onAddFilter,
            stateManager: searchEmbeddable.stateManager
          }))));
        }
      };
    }
  };
  return savedSearchEmbeddableFactory;
};
exports.getSearchEmbeddableFactory = getSearchEmbeddableFactory;