"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecurityRootProfileProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _securitySolutionCommon = require("@kbn/security-solution-common");
var _profiles = require("../../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSecurityRootProfileProvider = services => ({
  profileId: 'security-root-profile',
  isExperimental: true,
  profile: {
    getCellRenderers: prev => params => ({
      ...prev(params),
      'host.name': props => {
        const CellRenderer = (0, _securitySolutionCommon.getDiscoverCellRenderer)({
          fieldName: 'host.name'
        });
        return /*#__PURE__*/_react.default.createElement(CellRenderer, props);
      }
    })
  },
  resolve: params => {
    if (params.solutionNavId === _profiles.SolutionType.Security) {
      return {
        isMatch: true,
        context: {
          solutionType: _profiles.SolutionType.Security
        }
      };
    }
    return {
      isMatch: false
    };
  }
});
exports.createSecurityRootProfileProvider = createSecurityRootProfileProvider;