"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExampleRootProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _react = _interopRequireDefault(require("react"));
var _profiles = require("../../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createExampleRootProfileProvider = () => ({
  profileId: 'example-root-profile',
  isExperimental: true,
  profile: {
    getCellRenderers: prev => params => ({
      ...prev(params),
      '@timestamp': props => {
        const timestamp = (0, _discoverUtils.getFieldValue)(props.row, '@timestamp');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          title: timestamp,
          "data-test-subj": "exampleRootProfileTimestamp"
        }, timestamp);
      }
    })
  },
  resolve: params => {
    if (params.solutionNavId != null) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        solutionType: _profiles.SolutionType.Default
      }
    };
  }
});
exports.createExampleRootProfileProvider = createExampleRootProfileProvider;