"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExampleDataSourceProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _data_sources = require("../../../../../common/data_sources");
var _profiles = require("../../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createExampleDataSourceProfileProvider = () => ({
  profileId: 'example-data-source-profile',
  isExperimental: true,
  profile: {
    getCellRenderers: prev => params => ({
      ...prev(params),
      'log.level': props => {
        const level = (0, _discoverUtils.getFieldValue)(props.row, 'log.level');
        if (!level) {
          return /*#__PURE__*/_react.default.createElement("span", {
            css: {
              color: _uiTheme.euiThemeVars.euiTextSubduedColor
            },
            "data-test-subj": "exampleDataSourceProfileLogLevelEmpty"
          }, "(None)");
        }
        const levelMap = {
          info: 'primary',
          debug: 'default',
          error: 'danger'
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: levelMap[level],
          title: level,
          "data-test-subj": "exampleDataSourceProfileLogLevel"
        }, (0, _lodash.capitalize)(level));
      }
    }),
    getDocViewer: prev => params => {
      const recordId = params.record.id;
      const prevValue = prev(params);
      return {
        title: `Record #${recordId}`,
        docViewsRegistry: registry => {
          registry.add({
            id: 'doc_view_example',
            title: 'Example',
            order: 0,
            component: () => /*#__PURE__*/_react.default.createElement("div", {
              "data-test-subj": "exampleDataSourceProfileDocView"
            }, "Example Doc View")
          });
          return prevValue.docViewsRegistry(registry);
        }
      };
    },
    getRowAdditionalLeadingControls: prev => params => {
      const additionalControls = prev(params) || [];
      return [...additionalControls, ...['visBarVerticalStacked', 'heart', 'inspect'].map((iconType, index) => ({
        id: `exampleControl_${iconType}`,
        headerAriaLabel: `Example Row Control ${iconType}`,
        renderControl: (Control, rowProps) => {
          return /*#__PURE__*/_react.default.createElement(Control, {
            "data-test-subj": `exampleLogsControl_${iconType}`,
            label: `Example ${iconType}`,
            tooltipContent: `Example ${iconType}`,
            iconType: iconType,
            onClick: () => {
              alert(`Example "${iconType}" control clicked. Row index: ${rowProps.rowIndex}`);
            }
          });
        }
      }))];
    },
    getDefaultAppState: () => () => ({
      columns: [{
        name: '@timestamp',
        width: 212
      }, {
        name: 'log.level',
        width: 150
      }, {
        name: 'message'
      }],
      rowHeight: 5
    }),
    getAdditionalCellActions: prev => () => [...prev(), {
      id: 'example-data-source-action',
      getDisplayName: () => 'Example data source action',
      getIconType: () => 'plus',
      execute: () => {
        alert('Example data source action executed');
      }
    }, {
      id: 'another-example-data-source-action',
      getDisplayName: () => 'Another example data source action',
      getIconType: () => 'minus',
      execute: () => {
        alert('Another example data source action executed');
      },
      isCompatible: ({
        field
      }) => field.name !== 'message'
    }]
  },
  resolve: params => {
    let indexPattern;
    if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.Esql)) {
      if (!(0, _esQuery.isOfAggregateQueryType)(params.query)) {
        return {
          isMatch: false
        };
      }
      indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(params.query.esql);
    } else if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.DataView) && params.dataView) {
      indexPattern = params.dataView.getIndexPattern();
    }
    if (indexPattern !== 'my-example-logs') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs
      }
    };
  }
});
exports.createExampleDataSourceProfileProvider = createExampleDataSourceProfileProvider;