"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSystemLogsDataSourceProfileProvider = void 0;
var _extend_profile_provider = require("../../../extend_profile_provider");
var _accessors = require("../accessors");
var _consts = require("../consts");
var _create_resolve = require("./create_resolve");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSystemLogsDataSourceProfileProvider = logsDataSourceProfileProvider => (0, _extend_profile_provider.extendProfileProvider)(logsDataSourceProfileProvider, {
  profileId: 'system-logs-data-source',
  profile: {
    getDefaultAppState: (0, _accessors.createGetDefaultAppState)({
      defaultColumns: [_consts.LOG_LEVEL_COLUMN, {
        name: 'process.name',
        width: 150
      }, _consts.HOST_NAME_COLUMN, _consts.MESSAGE_COLUMN]
    })
  },
  resolve: (0, _create_resolve.createResolve)('logs-system')
});
exports.createSystemLogsDataSourceProfileProvider = createSystemLogsDataSourceProfileProvider;