"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsDataSourceProfileProviders = void 0;
var _profile = require("./profile");
var _sub_profiles = require("./sub_profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createLogsDataSourceProfileProviders = providerServices => {
  const logsDataSourceProfileProvider = (0, _profile.createLogsDataSourceProfileProvider)(providerServices);
  return [(0, _sub_profiles.createSystemLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createKubernetesContainerLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createWindowsLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createAwsS3accessLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createNginxErrorLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createNginxAccessLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), (0, _sub_profiles.createApacheErrorLogsDataSourceProfileProvider)(logsDataSourceProfileProvider), logsDataSourceProfileProvider];
};
exports.createLogsDataSourceProfileProviders = createLogsDataSourceProfileProviders;