"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCellRenderers = void 0;
var _unifiedDataTable = require("@kbn/unified-data-table");
var _summary_column = require("../../../../../components/data_types/logs/summary_column");
var _constants = require("../../../../../../common/data_types/logs/constants");
var _log_level_badge_cell = require("../../../../../components/data_types/logs/log_level_badge_cell");
var _service_name_cell = require("../../../../../components/data_types/logs/service_name_cell");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getCellRenderers = prev => params => ({
  ...prev(params),
  ..._constants.LOG_LEVEL_FIELDS.reduce((acc, field) => ({
    ...acc,
    [field]: (0, _log_level_badge_cell.getLogLevelBadgeCell)(field),
    [`${field}.keyword`]: (0, _log_level_badge_cell.getLogLevelBadgeCell)(`${field}.keyword`)
  }), {}),
  ..._constants.SERVICE_NAME_FIELDS.reduce((acc, field) => ({
    ...acc,
    [field]: (0, _service_name_cell.getServiceNameCell)(field),
    [`${field}.keyword`]: (0, _service_name_cell.getServiceNameCell)(`${field}.keyword`)
  }), {}),
  [_unifiedDataTable.SOURCE_COLUMN]: (0, _summary_column.getSummaryColumn)(params)
});
exports.getCellRenderers = getCellRenderers;