"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogDocumentProfileProvider = void 0;
var _profiles = require("../../../profiles");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createLogDocumentProfileProvider = services => ({
  profileId: 'log-document-profile',
  profile: {
    getDocViewer: _accessors.getDocViewer
  },
  resolve: ({
    record
  }) => {
    const isLogRecord = getIsLogRecord(record, services.logsContextService.isLogsIndexPattern);
    if (!isLogRecord) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        type: _profiles.DocumentType.Log
      }
    };
  }
});
exports.createLogDocumentProfileProvider = createLogDocumentProfileProvider;
const getIsLogRecord = (record, isLogsIndexPattern) => {
  return getDataStreamType(record).includes('logs') || hasFieldsWithPrefix('log.')(record) || getIndices(record).some(isLogsIndexPattern);
};
const getFieldValues = field => record => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value : [value];
};
const getDataStreamType = getFieldValues('data_stream.type');
const getIndices = getFieldValues('_index');
const hasFieldsWithPrefix = prefix => record => {
  return Object.keys(record.flattened).some(field => field.startsWith(prefix) && record.flattened[field] != null);
};