"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocViewer = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDocViewer = prev => params => {
  const prevDocViewer = prev(params);
  return {
    ...prevDocViewer,
    docViewsRegistry: registry => {
      registry.add({
        id: 'doc_view_logs_overview',
        title: _i18n.i18n.translate('discover.docViews.logsOverview.title', {
          defaultMessage: 'Log overview'
        }),
        order: 0,
        component: props => /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerLogsOverview, props)
      });
      return prevDocViewer.docViewsRegistry(registry);
    }
  };
};
exports.getDocViewer = getDocViewer;