"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdditionalCellActions = exports.toCellActionContext = exports.createCellAction = exports.DISCOVER_CELL_ACTION_TYPE = void 0;
var _actions = require("@kbn/cell-actions/actions");
var _react = require("react");
var _uuid = require("uuid");
var _types = require("../types");
var _use_discover_services = require("../../hooks/use_discover_services");
var _use_profile_accessor = require("./use_profile_accessor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DISCOVER_CELL_ACTION_TYPE = exports.DISCOVER_CELL_ACTION_TYPE = 'discover-cellAction-type';

/**
 * Hook to register additional cell actions based on the resolved profiles
 * @param options Additional cell action options
 * @returns The current cell actions metadata
 */
const useAdditionalCellActions = ({
  dataSource,
  dataView,
  query,
  filters,
  timeRange
}) => {
  const {
    uiActions
  } = (0, _use_discover_services.useDiscoverServices)();
  const [instanceId, setInstanceId] = (0, _react.useState)();
  const getAdditionalCellActionsAccessor = (0, _use_profile_accessor.useProfileAccessor)('getAdditionalCellActions');
  const additionalCellActions = (0, _react.useMemo)(() => getAdditionalCellActionsAccessor(() => [])(), [getAdditionalCellActionsAccessor]);
  (0, _react.useEffect)(() => {
    const currentInstanceId = (0, _uuid.v4)();
    const actions = additionalCellActions.map((action, i) => createCellAction(currentInstanceId, action, i));
    actions.forEach(action => {
      uiActions.registerAction(action);
      uiActions.attachAction(_types.DISCOVER_CELL_ACTIONS_TRIGGER.id, action.id);
    });
    setInstanceId(currentInstanceId);
    return () => {
      actions.forEach(action => {
        uiActions.detachAction(_types.DISCOVER_CELL_ACTIONS_TRIGGER.id, action.id);
        uiActions.unregisterAction(action.id);
      });
      setInstanceId(undefined);
    };
  }, [additionalCellActions, uiActions]);
  return (0, _react.useMemo)(() => ({
    instanceId,
    dataSource,
    dataView,
    query,
    filters,
    timeRange
  }), [dataSource, dataView, filters, instanceId, query, timeRange]);
};
exports.useAdditionalCellActions = useAdditionalCellActions;
const createCellAction = (instanceId, action, order) => {
  const createFactory = (0, _actions.createCellActionFactory)(() => ({
    type: DISCOVER_CELL_ACTION_TYPE,
    getIconType: context => action.getIconType(toCellActionContext(context)),
    getDisplayName: context => action.getDisplayName(toCellActionContext(context)),
    getDisplayNameTooltip: context => action.getDisplayName(toCellActionContext(context)),
    execute: async context => action.execute(toCellActionContext(context)),
    isCompatible: async ({
      data,
      metadata
    }) => {
      var _data$, _metadata$dataView, _action$isCompatible, _action$isCompatible2;
      if ((metadata === null || metadata === void 0 ? void 0 : metadata.instanceId) !== instanceId || data.length !== 1) {
        return false;
      }
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field;
      if (!field || !((_metadata$dataView = metadata.dataView) !== null && _metadata$dataView !== void 0 && _metadata$dataView.getFieldByName(field.name))) {
        return false;
      }
      return (_action$isCompatible = (_action$isCompatible2 = action.isCompatible) === null || _action$isCompatible2 === void 0 ? void 0 : _action$isCompatible2.call(action, {
        field,
        ...metadata
      })) !== null && _action$isCompatible !== void 0 ? _action$isCompatible : true;
    }
  }));
  const factory = createFactory();
  return factory({
    id: `${action.id}-${(0, _uuid.v4)()}`,
    order
  });
};
exports.createCellAction = createCellAction;
const toCellActionContext = ({
  data,
  metadata
}) => ({
  ...data[0],
  ...metadata
});
exports.toCellActionContext = toCellActionContext;