"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMergedAccessor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A partial profile implementation
 */

/**
 * An accessor function that allows retrieving the extension point result from previous profiles
 */

/**
 * A partial profile implementation that supports composition across multiple profiles
 */

/**
 * Merges extension point implementations from multiple profiles into a single accessor function
 * @param profiles The profiles to merge
 * @param key The key of the extension point to merge
 * @param baseImpl The base implementation for the extension point
 * @returns The merged extension point accessor function
 */
const getMergedAccessor = (profiles, key, baseImpl) => {
  // root, data source, and document profiles are merged in order
  return profiles.reduce((nextAccessor, profile) => {
    const currentAccessor = profile[key];
    return currentAccessor ? currentAccessor(nextAccessor) : nextAccessor;
  }, baseImpl);
};
exports.getMergedAccessor = getMergedAccessor;