"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DiscoverContainerInternal = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _main = require("../../application/main");
var _loading_indicator = require("../common/loading_indicator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const discoverContainerWrapperCss = (0, _react2.css)`
  width: 100%;
  height: 100%;

  // override the embedded discover page height
  // to fit in the container
  .dscPage {
    height: 100%;
  }
`;
const customizationContext = {
  solutionNavId: null,
  displayMode: 'embedded',
  inlineTopNav: {
    enabled: false,
    showLogsExplorerTabs: false
  }
};
const DiscoverContainerInternal = ({
  overrideServices,
  scopedHistory,
  customizationCallbacks,
  getDiscoverServices,
  stateStorageContainer,
  isLoading = false
}) => {
  const services = (0, _react.useMemo)(() => {
    return {
      ...getDiscoverServices(),
      ...overrideServices,
      getScopedHistory: () => scopedHistory
    };
  }, [getDiscoverServices, overrideServices, scopedHistory]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: discoverContainerWrapperCss
    }, /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      type: "spinner"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: discoverContainerWrapperCss,
    "data-test-subj": "discover-container-internal-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
          width: 100%;
        `
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, {
    customizationCallbacks: customizationCallbacks,
    customizationContext: customizationContext,
    stateStorageContainer: stateStorageContainer
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.DiscoverContainerInternal = DiscoverContainerInternal;
var _default = exports.default = DiscoverContainerInternal;