"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnformattedResourceFields = exports.formatJsonDocumentForContent = exports.createResourceFields = void 0;
var _src = require("@kbn/discover-utils/src");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _get_available_resource_fields = require("../../../../utils/get_available_resource_fields");
var constants = _interopRequireWildcard(require("../../../../../common/data_types/logs/constants"));
var _service_name_badge_with_actions = require("../service_name_badge_with_actions");
var _cell_actions_popover = require("../cell_actions_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * getUnformattedResourceFields definitions
 */
const getUnformattedResourceFields = doc => {
  const serviceName = (0, _src.getFieldValue)(doc, constants.SERVICE_NAME_FIELD);
  const hostName = (0, _src.getFieldValue)(doc, constants.HOST_NAME_FIELD);
  const agentName = (0, _src.getFieldValue)(doc, constants.AGENT_NAME_FIELD);
  const orchestratorClusterName = (0, _src.getFieldValue)(doc, constants.ORCHESTRATOR_CLUSTER_NAME_FIELD);
  const orchestratorResourceId = (0, _src.getFieldValue)(doc, constants.ORCHESTRATOR_RESOURCE_ID_FIELD);
  const orchestratorNamespace = (0, _src.getFieldValue)(doc, constants.ORCHESTRATOR_NAMESPACE_FIELD);
  const containerName = (0, _src.getFieldValue)(doc, constants.CONTAINER_NAME_FIELD);
  const containerId = (0, _src.getFieldValue)(doc, constants.CONTAINER_ID_FIELD);
  const cloudInstanceId = (0, _src.getFieldValue)(doc, constants.CLOUD_INSTANCE_ID_FIELD);
  return {
    [constants.SERVICE_NAME_FIELD]: serviceName,
    [constants.HOST_NAME_FIELD]: hostName,
    [constants.AGENT_NAME_FIELD]: agentName,
    [constants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: orchestratorClusterName,
    [constants.ORCHESTRATOR_RESOURCE_ID_FIELD]: orchestratorResourceId,
    [constants.ORCHESTRATOR_NAMESPACE_FIELD]: orchestratorNamespace,
    [constants.CONTAINER_NAME_FIELD]: containerName,
    [constants.CONTAINER_ID_FIELD]: containerId,
    [constants.CLOUD_INSTANCE_ID_FIELD]: cloudInstanceId
  };
};

/**
 * createResourceFields definitions
 */
exports.getUnformattedResourceFields = getUnformattedResourceFields;
const AgentIcon = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/custom-icons/src/components/agent_icon'))));
const resourceCustomComponentsMap = {
  [constants.SERVICE_NAME_FIELD]: _service_name_badge_with_actions.ServiceNameBadgeWithActions
};
const createResourceFields = row => {
  const resourceDoc = getUnformattedResourceFields(row);
  const availableResourceFields = (0, _get_available_resource_fields.getAvailableResourceFields)(resourceDoc);
  const resourceFields = availableResourceFields.map(name => {
    var _resourceCustomCompon;
    return {
      name,
      value: resourceDoc[name],
      ResourceBadge: (_resourceCustomCompon = resourceCustomComponentsMap[name]) !== null && _resourceCustomCompon !== void 0 ? _resourceCustomCompon : _cell_actions_popover.FieldBadgeWithActions,
      ...(name === constants.SERVICE_NAME_FIELD && {
        Icon: () => /*#__PURE__*/_react.default.createElement(AgentIcon, {
          agentName: resourceDoc[constants.AGENT_NAME_FIELD],
          size: "m",
          css: (0, _react2.css)`
            margin-right: ${_uiTheme.euiThemeVars.euiSizeXS};
          `
        })
      })
    };
  });
  return resourceFields;
};

/**
 * formatJsonDocumentForContent definitions
 */
exports.createResourceFields = createResourceFields;
const formatJsonDocumentForContent = row => {
  const flattenedResult = {};
  const rawFieldResult = {};
  const {
    raw,
    flattened
  } = row;
  const {
    fields
  } = raw;

  // We need 2 loops here for flattened and raw.fields. Flattened contains all fields,
  // whereas raw.fields only contains certain fields excluding _ignored
  for (const fieldName in flattened) {
    if (isFieldAllowed(fieldName) && flattened[fieldName]) {
      flattenedResult[fieldName] = flattened[fieldName];
    }
  }
  for (const fieldName in fields) {
    if (isFieldAllowed(fieldName) && fields[fieldName]) {
      rawFieldResult[fieldName] = fields[fieldName];
    }
  }
  return {
    ...row,
    flattened: flattenedResult,
    raw: {
      ...raw,
      fields: rawFieldResult
    }
  };
};
exports.formatJsonDocumentForContent = formatJsonDocumentForContent;
const isFieldAllowed = field => !constants.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT.some(prefix => field.startsWith(prefix));