"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _resource = require("./resource");
var _content = require("./content");
var _translations = require("../translations");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SummaryColumn = props => {
  const {
    isDetails
  } = props;
  if (isDetails) {
    return /*#__PURE__*/_react.default.createElement(SummaryCellPopover, props);
  }
  return /*#__PURE__*/_react.default.createElement(SummaryCell, props);
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SummaryColumn;
const SummaryCell = ({
  density: maybeNullishDensity,
  rowHeight: maybeNullishRowHeight,
  ...props
}) => {
  const {
    onFilter,
    row
  } = props;
  const density = maybeNullishDensity !== null && maybeNullishDensity !== void 0 ? maybeNullishDensity : _unifiedDataTable.DataGridDensity.COMPACT;
  const isCompressed = density === _unifiedDataTable.DataGridDensity.COMPACT;
  const rowHeight = maybeNullishRowHeight !== null && maybeNullishRowHeight !== void 0 ? maybeNullishRowHeight : _unifiedDataTable.ROWS_HEIGHT_OPTIONS.single;
  const isSingleLine = rowHeight === _unifiedDataTable.ROWS_HEIGHT_OPTIONS.single || rowHeight === 1;
  const resourceFields = (0, _utils.createResourceFields)(row);
  const shouldRenderResource = resourceFields.length > 0;
  return isSingleLine ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, shouldRenderResource && /*#__PURE__*/_react.default.createElement(_resource.Resource, {
    fields: resourceFields,
    limited: isSingleLine,
    onFilter: onFilter,
    css: singleLineResourceCss
  }), /*#__PURE__*/_react.default.createElement(_content.Content, (0, _extends2.default)({}, props, {
    isCompressed: isCompressed,
    isSingleLine: true
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldRenderResource && /*#__PURE__*/_react.default.createElement(_resource.Resource, {
    fields: resourceFields,
    limited: isSingleLine,
    onFilter: onFilter,
    css: multiLineResourceCss
  }), /*#__PURE__*/_react.default.createElement(_content.Content, (0, _extends2.default)({}, props, {
    isCompressed: isCompressed
  })));
};
const SummaryCellPopover = props => {
  const {
    row,
    dataView,
    fieldFormats,
    onFilter,
    closePopover
  } = props;
  const resourceFields = (0, _utils.createResourceFields)(row);
  const shouldRenderResource = resourceFields.length > 0;
  const documentOverview = (0, _discoverUtils.getLogDocumentOverview)(row, {
    dataView,
    fieldFormats
  });
  const {
    field,
    value
  } = (0, _discoverUtils.getMessageFieldWithFallbacks)(documentOverview);
  const shouldRenderContent = Boolean(field && value);
  const shouldRenderSource = !shouldRenderContent;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: {
      position: 'relative',
      width: 580
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.closeCellActionPopoverText,
    "data-test-subj": "docTableClosePopover",
    iconSize: "s",
    iconType: "cross",
    size: "xs",
    onClick: closePopover,
    css: {
      position: 'absolute',
      right: 0
    }
  }), shouldRenderResource && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.resourceLabel)), /*#__PURE__*/_react.default.createElement(_resource.Resource, {
    fields: resourceFields,
    onFilter: onFilter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.contentLabel)), shouldRenderContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, field), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 100,
    paddingSize: "s",
    isCopyable: true,
    language: "txt",
    fontSize: "s"
  }, value)), shouldRenderSource && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _translations.jsonLabel), /*#__PURE__*/_react.default.createElement(_public.JsonCodeEditor, {
    json: (0, _utils.formatJsonDocumentForContent)(row).raw,
    height: 300
  }))));
};
const singleLineResourceCss = {
  flexGrow: 0,
  lineHeight: 'normal',
  marginTop: -1
};
const multiLineResourceCss = {
  display: 'inline-flex'
};
module.exports = exports.default;