"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Content = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discoverUtils = require("@kbn/discover-utils");
var constants = _interopRequireWildcard(require("../../../../../common/data_types/logs/constants"));
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LogMessage = ({
  field,
  value,
  className
}) => {
  const shouldRenderFieldName = field !== constants.MESSAGE_FIELD;
  if (shouldRenderFieldName) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: className
    }, /*#__PURE__*/_react.default.createElement("strong", null, field), ' ', /*#__PURE__*/_react.default.createElement("span", {
      className: className,
      "data-test-subj": "discoverDataTableMessageValue"
      // eslint-disable-next-line react/no-danger
      ,
      dangerouslySetInnerHTML: {
        __html: value
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("p", {
    className: className,
    "data-test-subj": "discoverDataTableMessageValue"
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: value
    }
  });
};
const Content = ({
  columnId,
  dataView,
  fieldFormats,
  isCompressed,
  isSingleLine = false,
  row,
  shouldShowFieldHandler
}) => {
  const documentOverview = (0, _discoverUtils.getLogDocumentOverview)(row, {
    dataView,
    fieldFormats
  });
  const {
    field,
    value
  } = (0, _discoverUtils.getMessageFieldWithFallbacks)(documentOverview);
  const shouldRenderContent = !!field && !!value;
  return shouldRenderContent ? /*#__PURE__*/_react.default.createElement(LogMessage, {
    field: field,
    value: value,
    className: isSingleLine ? 'eui-textTruncate' : ''
  }) : /*#__PURE__*/_react.default.createElement(FormattedSourceDocument, {
    columnId: columnId,
    dataView: dataView,
    fieldFormats: fieldFormats,
    shouldShowFieldHandler: shouldShowFieldHandler,
    isCompressed: isCompressed,
    row: row
  });
};
exports.Content = Content;
const FormattedSourceDocument = ({
  row,
  ...props
}) => {
  const formattedRow = (0, _react.useMemo)(() => (0, _utils.formatJsonDocumentForContent)(row), [row]);
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.SourceDocument, (0, _extends2.default)({
    maxEntries: 50,
    row: formattedRow,
    useTopLevelObjectColumns: false
  }, props));
};