"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNameBadgeWithActions = ServiceNameBadgeWithActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _routerUtils = require("@kbn/router-utils");
var _eui = require("@elastic/eui");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _cell_actions_popover = require("./cell_actions_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SERVICE_ENTITY_LOCATOR = 'SERVICE_ENTITY_LOCATOR';
function ServiceNameBadgeWithActions(props) {
  var _core$application$cap;
  const {
    share,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const canViewApm = ((_core$application$cap = core.application.capabilities.apm) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) || false;
  const isEntityCentricExperienceSettingEnabled = canViewApm ? core.uiSettings.get(_managementSettingsIds.OBSERVABILITY_ENTITY_CENTRIC_EXPERIENCE) : false;
  const derivedPropsForEntityExperience = isEntityCentricExperienceSettingEnabled ? getDerivedPropsForEntityExperience({
    serviceName: props.value,
    share
  }) : {};
  return /*#__PURE__*/_react.default.createElement(_cell_actions_popover.FieldBadgeWithActions, (0, _extends2.default)({}, props, derivedPropsForEntityExperience));
}
const getDerivedPropsForEntityExperience = ({
  serviceName,
  share
}) => {
  var _share$url;
  const apmLinkToServiceEntityLocator = share === null || share === void 0 ? void 0 : (_share$url = share.url) === null || _share$url === void 0 ? void 0 : _share$url.locators.get(SERVICE_ENTITY_LOCATOR);
  const href = apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.getRedirectUrl({
    serviceName
  });
  const routeLinkProps = href ? (0, _routerUtils.getRouterLinkProps)({
    href,
    onClick: () => apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.navigate({
      serviceName
    })
  }) : undefined;
  if (routeLinkProps) {
    return {
      renderValue: value => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, routeLinkProps, value)
    };
  }
  return {};
};