"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogLevelBadgeCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dataTestSubj = 'logLevelBadgeCell';
const badgeCss = {
  marginTop: '-4px'
};
const getLogLevelBadgeCell = logLevelField => props => {
  const value = props.row.flattened[logLevelField];
  if (!value) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `${dataTestSubj}-empty`
    }, "-");
  }
  return /*#__PURE__*/_react.default.createElement(_discoverUtils.LogLevelBadge, {
    logLevel: value,
    fallback: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `${dataTestSubj}-unknown`
    }, value),
    "data-test-subj": dataTestSubj,
    css: badgeCss
  });
};
exports.getLogLevelBadgeCell = getLogLevelBadgeCell;