"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActionsPopover = CellActionsPopover;
exports.FieldBadgeWithActions = FieldBadgeWithActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactHooks = require("@kbn/react-hooks");
var _uiTheme = require("@kbn/ui-theme");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const codeFontCSS = (0, _react2.css)`
  font-family: ${_uiTheme.euiThemeVars.euiCodeFontFamily};
`;
function CellActionsPopover({
  onFilter,
  property,
  value,
  renderValue,
  renderPopoverTrigger
}) {
  const [isPopoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const makeFilterHandlerByOperator = operator => () => {
    if (onFilter) {
      onFilter(property, value, operator);
    }
  };
  const popoverTriggerProps = {
    onClick: togglePopover,
    onClickAriaLabel: _translations.openCellActionPopoverAriaText,
    'data-test-subj': `dataTableCellActionsPopover_${property}`
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: renderPopoverTrigger({
      popoverTriggerProps
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "dataTableCellActionPopoverTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: codeFontCSS
  }, /*#__PURE__*/_react.default.createElement("strong", null, property), ' ', typeof renderValue === 'function' ? renderValue(value) : value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.closeCellActionPopoverText,
    "data-test-subj": "dataTableExpandCellActionPopoverClose",
    iconSize: "s",
    iconType: "cross",
    size: "xs",
    onClick: closePopover
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    key: "addToFilterAction",
    size: "s",
    iconType: "plusInCircle",
    "aria-label": (0, _translations.actionFilterForText)(value),
    onClick: makeFilterHandlerByOperator('+'),
    "data-test-subj": `dataTableCellAction_addToFilterAction_${property}`
  }, _translations.filterForText), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    key: "removeFromFilterAction",
    size: "s",
    iconType: "minusInCircle",
    "aria-label": (0, _translations.actionFilterOutText)(value),
    onClick: makeFilterHandlerByOperator('-'),
    "data-test-subj": `dataTableCellAction_removeFromFilterAction_${property}`
  }, _translations.filterOutText))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: value
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    key: "copyToClipboardAction",
    size: "s",
    iconType: "copyClipboard",
    "aria-label": (0, _translations.copyValueAriaText)(property),
    onClick: copy,
    "data-test-subj": `dataTableCellAction_copyToClipboardAction_${property}`
  }, _translations.copyValueText))));
}
function FieldBadgeWithActions({
  icon,
  onFilter,
  property,
  renderValue,
  value
}) {
  return /*#__PURE__*/_react.default.createElement(CellActionsPopover, {
    onFilter: onFilter,
    property: property,
    value: value,
    renderValue: renderValue,
    renderPopoverTrigger: ({
      popoverTriggerProps
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, popoverTriggerProps, {
      color: "hollow",
      iconType: icon,
      iconSide: "left"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: value,
      truncation: "middle",
      width: 120
    }))
  });
}