"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFiltersReferences = void 0;
var _public = require("@kbn/unified-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateFiltersReferences = ({
  prevDataView,
  nextDataView,
  services: {
    uiActions
  }
}) => {
  const trigger = uiActions.getTrigger(_public.UPDATE_FILTER_REFERENCES_TRIGGER);
  const action = uiActions.getAction(_public.UPDATE_FILTER_REFERENCES_ACTION);
  action === null || action === void 0 ? void 0 : action.execute({
    trigger,
    fromDataView: prevDataView.id,
    toDataView: nextDataView.id,
    usedDataViews: []
  });
};
exports.updateFiltersReferences = updateFiltersReferences;