"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchPanel = OpenSearchPanel;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _use_discover_services = require("../../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SEARCH_OBJECT_TYPE = 'search';
function OpenSearchPanel(props) {
  var _capabilities$savedOb, _capabilities$savedOb2;
  const {
    addBasePath,
    capabilities,
    savedObjectsTagging,
    contentClient,
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const hasSavedObjectPermission = ((_capabilities$savedOb = capabilities.savedObjectsManagement) === null || _capabilities$savedOb === void 0 ? void 0 : _capabilities$savedOb.edit) || ((_capabilities$savedOb2 = capabilities.savedObjectsManagement) === null || _capabilities$savedOb2 === void 0 ? void 0 : _capabilities$savedOb2.delete);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: props.onClose,
    "data-test-subj": "loadSearchForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openSearchPanel.openSearchTitle",
    defaultMessage: "Open search"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    services: {
      savedObjectsTagging,
      contentClient,
      uiSettings
    },
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.topNav.openSearchPanel.noSearchesFoundDescription",
      defaultMessage: "No matching searches found."
    }),
    savedObjectMetaData: [{
      type: SEARCH_OBJECT_TYPE,
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('discover.savedSearch.savedObjectName', {
        defaultMessage: 'Saved search'
      })
    }],
    onChoose: id => {
      props.onOpenSavedSearch(id);
      props.onClose();
    },
    showFilter: true
  })), hasSavedObjectPermission && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: props.onClose,
    "data-test-subj": "manageSearchesBtn",
    href: addBasePath(`/app/management/kibana/objects?initialQuery=type:(${SEARCH_OBJECT_TYPE})`)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openSearchPanel.manageSearchesButtonLabel",
    defaultMessage: "Manage searches"
  }))))));
}