"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ESQLToDataViewTransitionModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
function ESQLToDataViewTransitionModal({
  onClose
}) {
  const [dismissModalChecked, setDismissModalChecked] = (0, _react.useState)(false);
  const onTransitionModalDismiss = (0, _react.useCallback)(e => {
    setDismissModalChecked(e.target.checked);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => onClose(),
    style: {
      width: 700
    },
    "data-test-subj": "discover-esql-to-dataview-modal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('discover.esqlToDataViewTransitionModal.title', {
    defaultMessage: 'Unsaved changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, _i18n.i18n.translate('discover.esqlToDataviewTransitionModalBody', {
    defaultMessage: 'Switching data views removes the current ES|QL query. Save this search to avoid losing work.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: _esqlUtils.FEEDBACK_LINK,
    target: "_blank"
  }, _i18n.i18n.translate('discover.esqlToDataViewTransitionModal.feedbackLink', {
    defaultMessage: 'Submit ES|QL feedback'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    css: {
      paddingBlockStart: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "dismiss-text-based-languages-transition-modal",
    label: _i18n.i18n.translate('discover.esqlToDataViewTransitionModal.dismissButtonLabel', {
      defaultMessage: "Don't ask me again"
    }),
    checked: dismissModalChecked,
    onChange: onTransitionModalDismiss
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(dismissModalChecked, false),
    color: "danger",
    iconType: "trash",
    "data-test-subj": "discover-esql-to-dataview-no-save-btn"
  }, _i18n.i18n.translate('discover.esqlToDataViewTransitionModal.closeButtonLabel', {
    defaultMessage: 'Discard and switch'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onClose(dismissModalChecked, true),
    fill: true,
    color: "primary",
    iconType: "save",
    "data-test-subj": "discover-esql-to-dataview-save-btn"
  }, _i18n.i18n.translate('discover.esqlToDataViewTransitionModal.saveButtonLabel', {
    defaultMessage: 'Save and switch'
  }))))))));
}
module.exports = exports.default;