"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverContextAppLocatorDefinition = exports.DISCOVER_CONTEXT_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DISCOVER_CONTEXT_APP_LOCATOR = exports.DISCOVER_CONTEXT_APP_LOCATOR = 'DISCOVER_CONTEXT_APP_LOCATOR';
class DiscoverContextAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DISCOVER_CONTEXT_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const useHash = this.deps.useHash;
      const {
        index,
        rowId,
        columns,
        filters,
        referrer
      } = params;
      const appState = {};
      const queryState = {};
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
      if (columns) appState.columns = columns;
      if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f));
      let dataViewId;
      const state = {
        referrer
      };
      if (typeof index === 'object') {
        state.dataViewSpec = index;
        dataViewId = index.id;
      } else {
        dataViewId = index;
      }
      let path = `#/context/${dataViewId}/${encodeURIComponent(rowId)}`;
      if (Object.keys(queryState).length) {
        path = (0, _public.setStateToKbnUrl)('_g', queryState, {
          useHash
        }, path);
      }
      if (Object.keys(appState).length) {
        path = (0, _public.setStateToKbnUrl)('_a', appState, {
          useHash
        }, path);
      }
      return {
        app: 'discover',
        path,
        state
      };
    });
    this.deps = deps;
  }
}
exports.DiscoverContextAppLocatorDefinition = DiscoverContextAppLocatorDefinition;