"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreDataChartAction = exports.ACTION_EXPLORE_DATA_CHART = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _abstract_explore_data_action = require("./abstract_explore_data_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_EXPLORE_DATA_CHART = exports.ACTION_EXPLORE_DATA_CHART = 'ACTION_EXPLORE_DATA_CHART';
/**
 * This is "Explore underlying data" action which appears in popup context
 * menu when user clicks a value in visualization or brushes a time range.
 */

class ExploreDataChartAction extends _abstract_explore_data_action.AbstractExploreDataAction {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", ACTION_EXPLORE_DATA_CHART);
    (0, _defineProperty2.default)(this, "type", ACTION_EXPLORE_DATA_CHART);
    (0, _defineProperty2.default)(this, "order", 200);
    (0, _defineProperty2.default)(this, "getLocation", async context => {
      var _context$filters;
      const {
        extractTimeRange
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      const {
        restOfFilters: filters,
        timeRange
      } = extractTimeRange((_context$filters = context.filters) !== null && _context$filters !== void 0 ? _context$filters : [], context.timeFieldName);
      return super.getLocation(context, {
        filters,
        timeRange
      });
    });
  }
  async isCompatible(context) {
    const {
      embeddable
    } = context;
    if ((0, _presentationPublishing.apiIsOfType)(embeddable, 'map')) {
      return false; // TODO: https://github.com/elastic/kibana/issues/73043
    }
    return (0, _presentationPublishing.apiPublishesPartialUnifiedSearch)(embeddable) && super.isCompatible(context);
  }
}
exports.ExploreDataChartAction = ExploreDataChartAction;