"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wildcardQuery = wildcardQuery;
var _queries = require("@kbn/observability-plugin/server/utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function wildcardQuery(field, value) {
  if ((0, _queries.isUndefinedOrNull)(value) || value === '') {
    return [];
  }
  return [{
    wildcard: {
      [field]: `*${value}*`
    }
  }];
}