"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrations = getIntegrations;
var _errors = require("@kbn/fleet-plugin/server/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIntegrations(options) {
  const {
    packageClient,
    logger
  } = options;
  const packages = await packageClient.getPackages();
  const installedPackages = packages.filter(p => p.status === 'installed');
  const integrations = await Promise.all(installedPackages.map(async p => ({
    name: p.name,
    title: p.title,
    version: p.version,
    icons: p.icons,
    datasets: await getDatasets({
      packageClient,
      logger,
      pkg: p
    })
  })));
  return integrations.filter(integration => Object.keys(integration.datasets).length > 0);
}
const getDatasets = async options => {
  var _await$fetchDatasets, _pkg$data_streams;
  const {
    packageClient,
    logger,
    pkg
  } = options;
  return (_await$fetchDatasets = await fetchDatasets({
    packageClient,
    logger,
    name: pkg.name,
    version: pkg.version
  })) !== null && _await$fetchDatasets !== void 0 ? _await$fetchDatasets : getDatasetsReadableName((_pkg$data_streams = pkg.data_streams) !== null && _pkg$data_streams !== void 0 ? _pkg$data_streams : []);
};
const fetchDatasets = async options => {
  try {
    var _pkg$packageInfo$data;
    const {
      packageClient,
      name,
      version
    } = options;
    const pkg = await packageClient.getPackage(name, version);
    return getDatasetsReadableName((_pkg$packageInfo$data = pkg.packageInfo.data_streams) !== null && _pkg$packageInfo$data !== void 0 ? _pkg$packageInfo$data : []);
  } catch (error) {
    // Custom integration
    if (error instanceof _errors.PackageNotFoundError) {
      return null;
    }
    const {
      name,
      version,
      logger
    } = options;
    logger.error(`There was an error when trying to fetch information about package ${name} version ${version}: ${error}`);
    return {};
  }
};
const getDatasetsReadableName = dataStreams => {
  return dataStreams.reduce((acc, curr) => ({
    ...acc,
    [curr.dataset]: curr.title
  }), {});
};